package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.ObservationId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeObservationRequest(observationId: ObservationId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeObservationRequest = {
    import DescribeObservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeObservationRequest
      .builder()
      .observationId(ObservationId.unwrap(observationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeObservationRequest.ReadOnly =
    zio.aws.applicationinsights.model.DescribeObservationRequest
      .wrap(buildAwsValue())
}
object DescribeObservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeObservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeObservationRequest =
      zio.aws.applicationinsights.model
        .DescribeObservationRequest(observationId)
    def observationId: ObservationId
    def getObservationId: ZIO[Any, Nothing, ObservationId] =
      ZIO.succeed(observationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeObservationRequest
  ) extends zio.aws.applicationinsights.model.DescribeObservationRequest.ReadOnly {
    override val observationId: ObservationId =
      zio.aws.applicationinsights.model.primitives
        .ObservationId(impl.observationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeObservationRequest
  ): zio.aws.applicationinsights.model.DescribeObservationRequest.ReadOnly =
    new Wrapper(impl)
}
