package zio.aws.applicationinsights.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.applicationinsights.model.primitives.{
  PaginationToken,
  MaxEntities
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListApplicationsRequest(
    maxResults: Optional[MaxEntities] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest = {
    import ListApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxEntities.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListApplicationsRequest.ReadOnly =
    zio.aws.applicationinsights.model.ListApplicationsRequest
      .wrap(buildAwsValue())
}
object ListApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ListApplicationsRequest =
      zio.aws.applicationinsights.model.ListApplicationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxEntities]
    def nextToken: Optional[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, MaxEntities] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest
  ) extends zio.aws.applicationinsights.model.ListApplicationsRequest.ReadOnly {
    override val maxResults: Optional[MaxEntities] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.MaxEntities(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest
  ): zio.aws.applicationinsights.model.ListApplicationsRequest.ReadOnly =
    new Wrapper(impl)
}
