package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.ResourceGroupName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteApplicationRequest(
    resourceGroupName: ResourceGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DeleteApplicationRequest = {
    import DeleteApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DeleteApplicationRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DeleteApplicationRequest.ReadOnly =
    zio.aws.applicationinsights.model.DeleteApplicationRequest
      .wrap(buildAwsValue())
}
object DeleteApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DeleteApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.DeleteApplicationRequest =
      zio.aws.applicationinsights.model
        .DeleteApplicationRequest(resourceGroupName)
    def resourceGroupName: ResourceGroupName
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DeleteApplicationRequest
  ) extends zio.aws.applicationinsights.model.DeleteApplicationRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DeleteApplicationRequest
  ): zio.aws.applicationinsights.model.DeleteApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
