package zio.aws.applicationinsights.model
import java.lang.Integer
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  LogPatternSetName,
  LogPatternRank,
  ResourceGroupName,
  LogPatternName,
  LogPatternRegex
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateLogPatternRequest(
    resourceGroupName: ResourceGroupName,
    patternSetName: LogPatternSetName,
    patternName: LogPatternName,
    pattern: LogPatternRegex,
    rank: LogPatternRank
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternRequest = {
    import CreateLogPatternRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .patternSetName(
        LogPatternSetName.unwrap(patternSetName): java.lang.String
      )
      .patternName(LogPatternName.unwrap(patternName): java.lang.String)
      .pattern(LogPatternRegex.unwrap(pattern): java.lang.String)
      .rank(LogPatternRank.unwrap(rank): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.CreateLogPatternRequest.ReadOnly =
    zio.aws.applicationinsights.model.CreateLogPatternRequest
      .wrap(buildAwsValue())
}
object CreateLogPatternRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.CreateLogPatternRequest =
      zio.aws.applicationinsights.model.CreateLogPatternRequest(
        resourceGroupName,
        patternSetName,
        patternName,
        pattern,
        rank
      )
    def resourceGroupName: ResourceGroupName
    def patternSetName: LogPatternSetName
    def patternName: LogPatternName
    def pattern: LogPatternRegex
    def rank: LogPatternRank
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getPatternSetName: ZIO[Any, Nothing, LogPatternSetName] =
      ZIO.succeed(patternSetName)
    def getPatternName: ZIO[Any, Nothing, LogPatternName] =
      ZIO.succeed(patternName)
    def getPattern: ZIO[Any, Nothing, LogPatternRegex] = ZIO.succeed(pattern)
    def getRank: ZIO[Any, Nothing, LogPatternRank] = ZIO.succeed(rank)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternRequest
  ) extends zio.aws.applicationinsights.model.CreateLogPatternRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val patternSetName: LogPatternSetName =
      zio.aws.applicationinsights.model.primitives
        .LogPatternSetName(impl.patternSetName())
    override val patternName: LogPatternName =
      zio.aws.applicationinsights.model.primitives
        .LogPatternName(impl.patternName())
    override val pattern: LogPatternRegex =
      zio.aws.applicationinsights.model.primitives
        .LogPatternRegex(impl.pattern())
    override val rank: LogPatternRank =
      zio.aws.applicationinsights.model.primitives.LogPatternRank(impl.rank())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternRequest
  ): zio.aws.applicationinsights.model.CreateLogPatternRequest.ReadOnly =
    new Wrapper(impl)
}
