package zio.aws.applicationinsights.model
import scala.jdk.CollectionConverters._
sealed trait CloudWatchEventSource {
  def unwrap: software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource
}
object CloudWatchEventSource {
  def wrap(
      value: software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource
  ): zio.aws.applicationinsights.model.CloudWatchEventSource = value match {
    case software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource.EC2 =>
      val r = EC2
      r
    case software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource.CODE_DEPLOY =>
      val r = CODE_DEPLOY
      r
    case software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource.HEALTH =>
      val r = HEALTH
      r
    case software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource.RDS =>
      val r = RDS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationinsights.model.CloudWatchEventSource {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource =
      software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2
      extends zio.aws.applicationinsights.model.CloudWatchEventSource {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource =
      software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource.EC2
  }
  case object CODE_DEPLOY
      extends zio.aws.applicationinsights.model.CloudWatchEventSource {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource =
      software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource.CODE_DEPLOY
  }
  case object HEALTH
      extends zio.aws.applicationinsights.model.CloudWatchEventSource {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource =
      software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource.HEALTH
  }
  case object RDS
      extends zio.aws.applicationinsights.model.CloudWatchEventSource {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource =
      software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource.RDS
  }
}
