package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  ComponentName,
  AutoConfigEnabled,
  ComponentConfiguration,
  Monitor,
  ResourceGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateComponentConfigurationRequest(
    resourceGroupName: ResourceGroupName,
    componentName: ComponentName,
    monitor: Optional[Monitor] = Optional.Absent,
    tier: Optional[zio.aws.applicationinsights.model.Tier] = Optional.Absent,
    componentConfiguration: Optional[ComponentConfiguration] = Optional.Absent,
    autoConfigEnabled: Optional[AutoConfigEnabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.UpdateComponentConfigurationRequest = {
    import UpdateComponentConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.UpdateComponentConfigurationRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .componentName(ComponentName.unwrap(componentName): java.lang.String)
      .optionallyWith(
        monitor.map(value => Monitor.unwrap(value): java.lang.Boolean)
      )(_.monitor)
      .optionallyWith(tier.map(value => value.unwrap))(_.tier)
      .optionallyWith(
        componentConfiguration.map(value =>
          ComponentConfiguration.unwrap(value): java.lang.String
        )
      )(_.componentConfiguration)
      .optionallyWith(
        autoConfigEnabled.map(value =>
          AutoConfigEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.autoConfigEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.UpdateComponentConfigurationRequest.ReadOnly =
    zio.aws.applicationinsights.model.UpdateComponentConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateComponentConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.UpdateComponentConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.UpdateComponentConfigurationRequest =
      zio.aws.applicationinsights.model.UpdateComponentConfigurationRequest(
        resourceGroupName,
        componentName,
        monitor.map(value => value),
        tier.map(value => value),
        componentConfiguration.map(value => value),
        autoConfigEnabled.map(value => value)
      )
    def resourceGroupName: ResourceGroupName
    def componentName: ComponentName
    def monitor: Optional[Monitor]
    def tier: Optional[zio.aws.applicationinsights.model.Tier]
    def componentConfiguration: Optional[ComponentConfiguration]
    def autoConfigEnabled: Optional[AutoConfigEnabled]
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getComponentName: ZIO[Any, Nothing, ComponentName] =
      ZIO.succeed(componentName)
    def getMonitor: ZIO[Any, AwsError, Monitor] =
      AwsError.unwrapOptionField("monitor", monitor)
    def getTier: ZIO[Any, AwsError, zio.aws.applicationinsights.model.Tier] =
      AwsError.unwrapOptionField("tier", tier)
    def getComponentConfiguration: ZIO[Any, AwsError, ComponentConfiguration] =
      AwsError.unwrapOptionField(
        "componentConfiguration",
        componentConfiguration
      )
    def getAutoConfigEnabled: ZIO[Any, AwsError, AutoConfigEnabled] =
      AwsError.unwrapOptionField("autoConfigEnabled", autoConfigEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateComponentConfigurationRequest
  ) extends zio.aws.applicationinsights.model.UpdateComponentConfigurationRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val componentName: ComponentName =
      zio.aws.applicationinsights.model.primitives
        .ComponentName(impl.componentName())
    override val monitor: Optional[Monitor] = zio.aws.core.internal
      .optionalFromNullable(impl.monitor())
      .map(value => zio.aws.applicationinsights.model.primitives.Monitor(value))
    override val tier: Optional[zio.aws.applicationinsights.model.Tier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tier())
        .map(value => zio.aws.applicationinsights.model.Tier.wrap(value))
    override val componentConfiguration: Optional[ComponentConfiguration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentConfiguration())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .ComponentConfiguration(value)
        )
    override val autoConfigEnabled: Optional[AutoConfigEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoConfigEnabled())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.AutoConfigEnabled(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateComponentConfigurationRequest
  ): zio.aws.applicationinsights.model.UpdateComponentConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
