package zio.aws.applicationinsights.model
import scala.jdk.CollectionConverters._
sealed trait ConfigurationEventStatus {
  def unwrap: software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventStatus
}
object ConfigurationEventStatus {
  def wrap(
      value: software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventStatus
  ): zio.aws.applicationinsights.model.ConfigurationEventStatus = value match {
    case software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventStatus.INFO =>
      val r = INFO
      r
    case software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventStatus.WARN =>
      val r = WARN
      r
    case software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventStatus.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationinsights.model.ConfigurationEventStatus {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventStatus =
      software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object INFO
      extends zio.aws.applicationinsights.model.ConfigurationEventStatus {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventStatus =
      software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventStatus.INFO
  }
  case object WARN
      extends zio.aws.applicationinsights.model.ConfigurationEventStatus {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventStatus =
      software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventStatus.WARN
  }
  case object ERROR
      extends zio.aws.applicationinsights.model.ConfigurationEventStatus {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventStatus =
      software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventStatus.ERROR
  }
}
