package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.ResourceGroupName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeApplicationRequest(
    resourceGroupName: ResourceGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationRequest = {
    import DescribeApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeApplicationRequest.ReadOnly =
    zio.aws.applicationinsights.model.DescribeApplicationRequest
      .wrap(buildAwsValue())
}
object DescribeApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeApplicationRequest =
      zio.aws.applicationinsights.model
        .DescribeApplicationRequest(resourceGroupName)
    def resourceGroupName: ResourceGroupName
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationRequest
  ) extends zio.aws.applicationinsights.model.DescribeApplicationRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationRequest
  ): zio.aws.applicationinsights.model.DescribeApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
