package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  ResourceGroupName,
  PaginationToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListProblemsResponse(
    problemList: Optional[Iterable[zio.aws.applicationinsights.model.Problem]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    resourceGroupName: Optional[ResourceGroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListProblemsResponse = {
    import ListProblemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListProblemsResponse
      .builder()
      .optionallyWith(
        problemList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.problemList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListProblemsResponse.ReadOnly =
    zio.aws.applicationinsights.model.ListProblemsResponse.wrap(buildAwsValue())
}
object ListProblemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListProblemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ListProblemsResponse =
      zio.aws.applicationinsights.model.ListProblemsResponse(
        problemList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        resourceGroupName.map(value => value)
      )
    def problemList
        : Optional[List[zio.aws.applicationinsights.model.Problem.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def resourceGroupName: Optional[ResourceGroupName]
    def getProblemList: ZIO[Any, AwsError, List[
      zio.aws.applicationinsights.model.Problem.ReadOnly
    ]] = AwsError.unwrapOptionField("problemList", problemList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListProblemsResponse
  ) extends zio.aws.applicationinsights.model.ListProblemsResponse.ReadOnly {
    override val problemList
        : Optional[List[zio.aws.applicationinsights.model.Problem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.problemList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.applicationinsights.model.Problem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.PaginationToken(value)
      )
    override val resourceGroupName: Optional[ResourceGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceGroupName())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListProblemsResponse
  ): zio.aws.applicationinsights.model.ListProblemsResponse.ReadOnly =
    new Wrapper(impl)
}
