package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListApplicationsResponse(
    applicationInfoList: Optional[
      Iterable[zio.aws.applicationinsights.model.ApplicationInfo]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListApplicationsResponse = {
    import ListApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListApplicationsResponse
      .builder()
      .optionallyWith(
        applicationInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applicationInfoList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListApplicationsResponse.ReadOnly =
    zio.aws.applicationinsights.model.ListApplicationsResponse
      .wrap(buildAwsValue())
}
object ListApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ListApplicationsResponse =
      zio.aws.applicationinsights.model.ListApplicationsResponse(
        applicationInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def applicationInfoList: Optional[
      List[zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getApplicationInfoList: ZIO[Any, AwsError, List[
      zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("applicationInfoList", applicationInfoList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListApplicationsResponse
  ) extends zio.aws.applicationinsights.model.ListApplicationsResponse.ReadOnly {
    override val applicationInfoList: Optional[
      List[zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationInfoList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationinsights.model.ApplicationInfo.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListApplicationsResponse
  ): zio.aws.applicationinsights.model.ListApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
