package zio.aws.applicationinsights.model
import scala.jdk.CollectionConverters._
sealed trait FeedbackValue {
  def unwrap
      : software.amazon.awssdk.services.applicationinsights.model.FeedbackValue
}
object FeedbackValue {
  def wrap(
      value: software.amazon.awssdk.services.applicationinsights.model.FeedbackValue
  ): zio.aws.applicationinsights.model.FeedbackValue = value match {
    case software.amazon.awssdk.services.applicationinsights.model.FeedbackValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationinsights.model.FeedbackValue.NOT_SPECIFIED =>
      val r = NOT_SPECIFIED
      r
    case software.amazon.awssdk.services.applicationinsights.model.FeedbackValue.USEFUL =>
      val r = USEFUL
      r
    case software.amazon.awssdk.services.applicationinsights.model.FeedbackValue.NOT_USEFUL =>
      val r = NOT_USEFUL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationinsights.model.FeedbackValue {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.FeedbackValue =
      software.amazon.awssdk.services.applicationinsights.model.FeedbackValue.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_SPECIFIED
      extends zio.aws.applicationinsights.model.FeedbackValue {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.FeedbackValue =
      software.amazon.awssdk.services.applicationinsights.model.FeedbackValue.NOT_SPECIFIED
  }
  case object USEFUL extends zio.aws.applicationinsights.model.FeedbackValue {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.FeedbackValue =
      software.amazon.awssdk.services.applicationinsights.model.FeedbackValue.USEFUL
  }
  case object NOT_USEFUL
      extends zio.aws.applicationinsights.model.FeedbackValue {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.FeedbackValue =
      software.amazon.awssdk.services.applicationinsights.model.FeedbackValue.NOT_USEFUL
  }
}
