package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  PaginationToken,
  LogPatternSetName,
  ResourceGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListLogPatternSetsResponse(
    resourceGroupName: Optional[ResourceGroupName] = Optional.Absent,
    logPatternSets: Optional[Iterable[LogPatternSetName]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsResponse = {
    import ListLogPatternSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsResponse
      .builder()
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .optionallyWith(
        logPatternSets.map(value =>
          value.map { item =>
            LogPatternSetName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.logPatternSets)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListLogPatternSetsResponse.ReadOnly =
    zio.aws.applicationinsights.model.ListLogPatternSetsResponse
      .wrap(buildAwsValue())
}
object ListLogPatternSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.ListLogPatternSetsResponse =
      zio.aws.applicationinsights.model.ListLogPatternSetsResponse(
        resourceGroupName.map(value => value),
        logPatternSets.map(value => value),
        nextToken.map(value => value)
      )
    def resourceGroupName: Optional[ResourceGroupName]
    def logPatternSets: Optional[List[LogPatternSetName]]
    def nextToken: Optional[PaginationToken]
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
    def getLogPatternSets: ZIO[Any, AwsError, List[LogPatternSetName]] =
      AwsError.unwrapOptionField("logPatternSets", logPatternSets)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsResponse
  ) extends zio.aws.applicationinsights.model.ListLogPatternSetsResponse.ReadOnly {
    override val resourceGroupName: Optional[ResourceGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceGroupName())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
        )
    override val logPatternSets: Optional[List[LogPatternSetName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logPatternSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.applicationinsights.model.primitives.LogPatternSetName(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsResponse
  ): zio.aws.applicationinsights.model.ListLogPatternSetsResponse.ReadOnly =
    new Wrapper(impl)
}
