package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  LogPatternName,
  LogPatternSetName,
  ResourceGroupName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteLogPatternRequest(
    resourceGroupName: ResourceGroupName,
    patternSetName: LogPatternSetName,
    patternName: LogPatternName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DeleteLogPatternRequest = {
    import DeleteLogPatternRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DeleteLogPatternRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .patternSetName(
        LogPatternSetName.unwrap(patternSetName): java.lang.String
      )
      .patternName(LogPatternName.unwrap(patternName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DeleteLogPatternRequest.ReadOnly =
    zio.aws.applicationinsights.model.DeleteLogPatternRequest
      .wrap(buildAwsValue())
}
object DeleteLogPatternRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DeleteLogPatternRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.DeleteLogPatternRequest =
      zio.aws.applicationinsights.model
        .DeleteLogPatternRequest(resourceGroupName, patternSetName, patternName)
    def resourceGroupName: ResourceGroupName
    def patternSetName: LogPatternSetName
    def patternName: LogPatternName
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getPatternSetName: ZIO[Any, Nothing, LogPatternSetName] =
      ZIO.succeed(patternSetName)
    def getPatternName: ZIO[Any, Nothing, LogPatternName] =
      ZIO.succeed(patternName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DeleteLogPatternRequest
  ) extends zio.aws.applicationinsights.model.DeleteLogPatternRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val patternSetName: LogPatternSetName =
      zio.aws.applicationinsights.model.primitives
        .LogPatternSetName(impl.patternSetName())
    override val patternName: LogPatternName =
      zio.aws.applicationinsights.model.primitives
        .LogPatternName(impl.patternName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DeleteLogPatternRequest
  ): zio.aws.applicationinsights.model.DeleteLogPatternRequest.ReadOnly =
    new Wrapper(impl)
}
