package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  CustomComponentName,
  ResourceGroupName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteComponentRequest(
    resourceGroupName: ResourceGroupName,
    componentName: CustomComponentName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DeleteComponentRequest = {
    import DeleteComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DeleteComponentRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .componentName(
        CustomComponentName.unwrap(componentName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DeleteComponentRequest.ReadOnly =
    zio.aws.applicationinsights.model.DeleteComponentRequest
      .wrap(buildAwsValue())
}
object DeleteComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DeleteComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.DeleteComponentRequest =
      zio.aws.applicationinsights.model
        .DeleteComponentRequest(resourceGroupName, componentName)
    def resourceGroupName: ResourceGroupName
    def componentName: CustomComponentName
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getComponentName: ZIO[Any, Nothing, CustomComponentName] =
      ZIO.succeed(componentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DeleteComponentRequest
  ) extends zio.aws.applicationinsights.model.DeleteComponentRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val componentName: CustomComponentName =
      zio.aws.applicationinsights.model.primitives
        .CustomComponentName(impl.componentName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DeleteComponentRequest
  ): zio.aws.applicationinsights.model.DeleteComponentRequest.ReadOnly =
    new Wrapper(impl)
}
