package zio.aws.applicationinsights.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.applicationinsights.model.primitives.{
  CodeDeployInstanceGroupId,
  MetricName,
  RdsEventMessage,
  XRayRequestAverageLatency,
  MetricNamespace,
  XRayRequestCount,
  LineTime,
  StatesInput,
  XRayNodeType,
  EbsCause,
  EbsRequestId,
  CodeDeployApplication,
  SourceType,
  S3EventName,
  CodeDeployDeploymentId,
  XRayErrorPercent,
  HealthEventArn,
  XRayThrottlePercent,
  RdsEventCategories,
  CodeDeployDeploymentGroup,
  EbsEvent,
  StatesExecutionArn,
  EndTime,
  StartTime,
  Value,
  HealthEventTypeCode,
  LogGroup,
  CloudWatchEventDetailType,
  SourceARN,
  Ec2State,
  ObservationId,
  EbsResult,
  CodeDeployState,
  LogText,
  XRayNodeName,
  StatesStatus,
  HealthEventDescription,
  XRayFaultPercent,
  HealthService,
  CloudWatchEventId,
  StatesArn,
  HealthEventTypeCategory
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Observation(
    id: Optional[ObservationId] = Optional.Absent,
    startTime: Optional[StartTime] = Optional.Absent,
    endTime: Optional[EndTime] = Optional.Absent,
    sourceType: Optional[SourceType] = Optional.Absent,
    sourceARN: Optional[SourceARN] = Optional.Absent,
    logGroup: Optional[LogGroup] = Optional.Absent,
    lineTime: Optional[LineTime] = Optional.Absent,
    logText: Optional[LogText] = Optional.Absent,
    logFilter: Optional[zio.aws.applicationinsights.model.LogFilter] =
      Optional.Absent,
    metricNamespace: Optional[MetricNamespace] = Optional.Absent,
    metricName: Optional[MetricName] = Optional.Absent,
    unit: Optional[zio.aws.applicationinsights.model.primitives.Unit] =
      Optional.Absent,
    value: Optional[Value] = Optional.Absent,
    cloudWatchEventId: Optional[CloudWatchEventId] = Optional.Absent,
    cloudWatchEventSource: Optional[
      zio.aws.applicationinsights.model.CloudWatchEventSource
    ] = Optional.Absent,
    cloudWatchEventDetailType: Optional[CloudWatchEventDetailType] =
      Optional.Absent,
    healthEventArn: Optional[HealthEventArn] = Optional.Absent,
    healthService: Optional[HealthService] = Optional.Absent,
    healthEventTypeCode: Optional[HealthEventTypeCode] = Optional.Absent,
    healthEventTypeCategory: Optional[HealthEventTypeCategory] =
      Optional.Absent,
    healthEventDescription: Optional[HealthEventDescription] = Optional.Absent,
    codeDeployDeploymentId: Optional[CodeDeployDeploymentId] = Optional.Absent,
    codeDeployDeploymentGroup: Optional[CodeDeployDeploymentGroup] =
      Optional.Absent,
    codeDeployState: Optional[CodeDeployState] = Optional.Absent,
    codeDeployApplication: Optional[CodeDeployApplication] = Optional.Absent,
    codeDeployInstanceGroupId: Optional[CodeDeployInstanceGroupId] =
      Optional.Absent,
    ec2State: Optional[Ec2State] = Optional.Absent,
    rdsEventCategories: Optional[RdsEventCategories] = Optional.Absent,
    rdsEventMessage: Optional[RdsEventMessage] = Optional.Absent,
    s3EventName: Optional[S3EventName] = Optional.Absent,
    statesExecutionArn: Optional[StatesExecutionArn] = Optional.Absent,
    statesArn: Optional[StatesArn] = Optional.Absent,
    statesStatus: Optional[StatesStatus] = Optional.Absent,
    statesInput: Optional[StatesInput] = Optional.Absent,
    ebsEvent: Optional[EbsEvent] = Optional.Absent,
    ebsResult: Optional[EbsResult] = Optional.Absent,
    ebsCause: Optional[EbsCause] = Optional.Absent,
    ebsRequestId: Optional[EbsRequestId] = Optional.Absent,
    xRayFaultPercent: Optional[XRayFaultPercent] = Optional.Absent,
    xRayThrottlePercent: Optional[XRayThrottlePercent] = Optional.Absent,
    xRayErrorPercent: Optional[XRayErrorPercent] = Optional.Absent,
    xRayRequestCount: Optional[XRayRequestCount] = Optional.Absent,
    xRayRequestAverageLatency: Optional[XRayRequestAverageLatency] =
      Optional.Absent,
    xRayNodeName: Optional[XRayNodeName] = Optional.Absent,
    xRayNodeType: Optional[XRayNodeType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.Observation = {
    import Observation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.Observation
      .builder()
      .optionallyWith(
        id.map(value => ObservationId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(startTime.map(value => StartTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => EndTime.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        sourceType.map(value => SourceType.unwrap(value): java.lang.String)
      )(_.sourceType)
      .optionallyWith(
        sourceARN.map(value => SourceARN.unwrap(value): java.lang.String)
      )(_.sourceARN)
      .optionallyWith(
        logGroup.map(value => LogGroup.unwrap(value): java.lang.String)
      )(_.logGroup)
      .optionallyWith(lineTime.map(value => LineTime.unwrap(value): Instant))(
        _.lineTime
      )
      .optionallyWith(
        logText.map(value => LogText.unwrap(value): java.lang.String)
      )(_.logText)
      .optionallyWith(logFilter.map(value => value.unwrap))(_.logFilter)
      .optionallyWith(
        metricNamespace.map(value =>
          MetricNamespace.unwrap(value): java.lang.String
        )
      )(_.metricNamespace)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        unit.map(value =>
          zio.aws.applicationinsights.model.primitives.Unit.unwrap(
            value
          ): java.lang.String
        )
      )(_.unit)
      .optionallyWith(
        value.map(value => Value.unwrap(value): java.lang.Double)
      )(_.value)
      .optionallyWith(
        cloudWatchEventId.map(value =>
          CloudWatchEventId.unwrap(value): java.lang.String
        )
      )(_.cloudWatchEventId)
      .optionallyWith(cloudWatchEventSource.map(value => value.unwrap))(
        _.cloudWatchEventSource
      )
      .optionallyWith(
        cloudWatchEventDetailType.map(value =>
          CloudWatchEventDetailType.unwrap(value): java.lang.String
        )
      )(_.cloudWatchEventDetailType)
      .optionallyWith(
        healthEventArn.map(value =>
          HealthEventArn.unwrap(value): java.lang.String
        )
      )(_.healthEventArn)
      .optionallyWith(
        healthService.map(value =>
          HealthService.unwrap(value): java.lang.String
        )
      )(_.healthService)
      .optionallyWith(
        healthEventTypeCode.map(value =>
          HealthEventTypeCode.unwrap(value): java.lang.String
        )
      )(_.healthEventTypeCode)
      .optionallyWith(
        healthEventTypeCategory.map(value =>
          HealthEventTypeCategory.unwrap(value): java.lang.String
        )
      )(_.healthEventTypeCategory)
      .optionallyWith(
        healthEventDescription.map(value =>
          HealthEventDescription.unwrap(value): java.lang.String
        )
      )(_.healthEventDescription)
      .optionallyWith(
        codeDeployDeploymentId.map(value =>
          CodeDeployDeploymentId.unwrap(value): java.lang.String
        )
      )(_.codeDeployDeploymentId)
      .optionallyWith(
        codeDeployDeploymentGroup.map(value =>
          CodeDeployDeploymentGroup.unwrap(value): java.lang.String
        )
      )(_.codeDeployDeploymentGroup)
      .optionallyWith(
        codeDeployState.map(value =>
          CodeDeployState.unwrap(value): java.lang.String
        )
      )(_.codeDeployState)
      .optionallyWith(
        codeDeployApplication.map(value =>
          CodeDeployApplication.unwrap(value): java.lang.String
        )
      )(_.codeDeployApplication)
      .optionallyWith(
        codeDeployInstanceGroupId.map(value =>
          CodeDeployInstanceGroupId.unwrap(value): java.lang.String
        )
      )(_.codeDeployInstanceGroupId)
      .optionallyWith(
        ec2State.map(value => Ec2State.unwrap(value): java.lang.String)
      )(_.ec2State)
      .optionallyWith(
        rdsEventCategories.map(value =>
          RdsEventCategories.unwrap(value): java.lang.String
        )
      )(_.rdsEventCategories)
      .optionallyWith(
        rdsEventMessage.map(value =>
          RdsEventMessage.unwrap(value): java.lang.String
        )
      )(_.rdsEventMessage)
      .optionallyWith(
        s3EventName.map(value => S3EventName.unwrap(value): java.lang.String)
      )(_.s3EventName)
      .optionallyWith(
        statesExecutionArn.map(value =>
          StatesExecutionArn.unwrap(value): java.lang.String
        )
      )(_.statesExecutionArn)
      .optionallyWith(
        statesArn.map(value => StatesArn.unwrap(value): java.lang.String)
      )(_.statesArn)
      .optionallyWith(
        statesStatus.map(value => StatesStatus.unwrap(value): java.lang.String)
      )(_.statesStatus)
      .optionallyWith(
        statesInput.map(value => StatesInput.unwrap(value): java.lang.String)
      )(_.statesInput)
      .optionallyWith(
        ebsEvent.map(value => EbsEvent.unwrap(value): java.lang.String)
      )(_.ebsEvent)
      .optionallyWith(
        ebsResult.map(value => EbsResult.unwrap(value): java.lang.String)
      )(_.ebsResult)
      .optionallyWith(
        ebsCause.map(value => EbsCause.unwrap(value): java.lang.String)
      )(_.ebsCause)
      .optionallyWith(
        ebsRequestId.map(value => EbsRequestId.unwrap(value): java.lang.String)
      )(_.ebsRequestId)
      .optionallyWith(
        xRayFaultPercent.map(value => XRayFaultPercent.unwrap(value): Integer)
      )(_.xRayFaultPercent)
      .optionallyWith(
        xRayThrottlePercent.map(value =>
          XRayThrottlePercent.unwrap(value): Integer
        )
      )(_.xRayThrottlePercent)
      .optionallyWith(
        xRayErrorPercent.map(value => XRayErrorPercent.unwrap(value): Integer)
      )(_.xRayErrorPercent)
      .optionallyWith(
        xRayRequestCount.map(value => XRayRequestCount.unwrap(value): Integer)
      )(_.xRayRequestCount)
      .optionallyWith(
        xRayRequestAverageLatency.map(value =>
          XRayRequestAverageLatency.unwrap(value): java.lang.Long
        )
      )(_.xRayRequestAverageLatency)
      .optionallyWith(
        xRayNodeName.map(value => XRayNodeName.unwrap(value): java.lang.String)
      )(_.xRayNodeName)
      .optionallyWith(
        xRayNodeType.map(value => XRayNodeType.unwrap(value): java.lang.String)
      )(_.xRayNodeType)
      .build()
  }
  def asReadOnly: zio.aws.applicationinsights.model.Observation.ReadOnly =
    zio.aws.applicationinsights.model.Observation.wrap(buildAwsValue())
}
object Observation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.Observation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.Observation =
      zio.aws.applicationinsights.model.Observation(
        id.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        sourceType.map(value => value),
        sourceARN.map(value => value),
        logGroup.map(value => value),
        lineTime.map(value => value),
        logText.map(value => value),
        logFilter.map(value => value),
        metricNamespace.map(value => value),
        metricName.map(value => value),
        unit.map(value => value),
        value.map(value => value),
        cloudWatchEventId.map(value => value),
        cloudWatchEventSource.map(value => value),
        cloudWatchEventDetailType.map(value => value),
        healthEventArn.map(value => value),
        healthService.map(value => value),
        healthEventTypeCode.map(value => value),
        healthEventTypeCategory.map(value => value),
        healthEventDescription.map(value => value),
        codeDeployDeploymentId.map(value => value),
        codeDeployDeploymentGroup.map(value => value),
        codeDeployState.map(value => value),
        codeDeployApplication.map(value => value),
        codeDeployInstanceGroupId.map(value => value),
        ec2State.map(value => value),
        rdsEventCategories.map(value => value),
        rdsEventMessage.map(value => value),
        s3EventName.map(value => value),
        statesExecutionArn.map(value => value),
        statesArn.map(value => value),
        statesStatus.map(value => value),
        statesInput.map(value => value),
        ebsEvent.map(value => value),
        ebsResult.map(value => value),
        ebsCause.map(value => value),
        ebsRequestId.map(value => value),
        xRayFaultPercent.map(value => value),
        xRayThrottlePercent.map(value => value),
        xRayErrorPercent.map(value => value),
        xRayRequestCount.map(value => value),
        xRayRequestAverageLatency.map(value => value),
        xRayNodeName.map(value => value),
        xRayNodeType.map(value => value)
      )
    def id: Optional[ObservationId]
    def startTime: Optional[StartTime]
    def endTime: Optional[EndTime]
    def sourceType: Optional[SourceType]
    def sourceARN: Optional[SourceARN]
    def logGroup: Optional[LogGroup]
    def lineTime: Optional[LineTime]
    def logText: Optional[LogText]
    def logFilter: Optional[zio.aws.applicationinsights.model.LogFilter]
    def metricNamespace: Optional[MetricNamespace]
    def metricName: Optional[MetricName]
    def unit: Optional[zio.aws.applicationinsights.model.primitives.Unit]
    def value: Optional[Value]
    def cloudWatchEventId: Optional[CloudWatchEventId]
    def cloudWatchEventSource
        : Optional[zio.aws.applicationinsights.model.CloudWatchEventSource]
    def cloudWatchEventDetailType: Optional[CloudWatchEventDetailType]
    def healthEventArn: Optional[HealthEventArn]
    def healthService: Optional[HealthService]
    def healthEventTypeCode: Optional[HealthEventTypeCode]
    def healthEventTypeCategory: Optional[HealthEventTypeCategory]
    def healthEventDescription: Optional[HealthEventDescription]
    def codeDeployDeploymentId: Optional[CodeDeployDeploymentId]
    def codeDeployDeploymentGroup: Optional[CodeDeployDeploymentGroup]
    def codeDeployState: Optional[CodeDeployState]
    def codeDeployApplication: Optional[CodeDeployApplication]
    def codeDeployInstanceGroupId: Optional[CodeDeployInstanceGroupId]
    def ec2State: Optional[Ec2State]
    def rdsEventCategories: Optional[RdsEventCategories]
    def rdsEventMessage: Optional[RdsEventMessage]
    def s3EventName: Optional[S3EventName]
    def statesExecutionArn: Optional[StatesExecutionArn]
    def statesArn: Optional[StatesArn]
    def statesStatus: Optional[StatesStatus]
    def statesInput: Optional[StatesInput]
    def ebsEvent: Optional[EbsEvent]
    def ebsResult: Optional[EbsResult]
    def ebsCause: Optional[EbsCause]
    def ebsRequestId: Optional[EbsRequestId]
    def xRayFaultPercent: Optional[XRayFaultPercent]
    def xRayThrottlePercent: Optional[XRayThrottlePercent]
    def xRayErrorPercent: Optional[XRayErrorPercent]
    def xRayRequestCount: Optional[XRayRequestCount]
    def xRayRequestAverageLatency: Optional[XRayRequestAverageLatency]
    def xRayNodeName: Optional[XRayNodeName]
    def xRayNodeType: Optional[XRayNodeType]
    def getId: ZIO[Any, AwsError, ObservationId] =
      AwsError.unwrapOptionField("id", id)
    def getStartTime: ZIO[Any, AwsError, StartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, EndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getSourceType: ZIO[Any, AwsError, SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getSourceARN: ZIO[Any, AwsError, SourceARN] =
      AwsError.unwrapOptionField("sourceARN", sourceARN)
    def getLogGroup: ZIO[Any, AwsError, LogGroup] =
      AwsError.unwrapOptionField("logGroup", logGroup)
    def getLineTime: ZIO[Any, AwsError, LineTime] =
      AwsError.unwrapOptionField("lineTime", lineTime)
    def getLogText: ZIO[Any, AwsError, LogText] =
      AwsError.unwrapOptionField("logText", logText)
    def getLogFilter
        : ZIO[Any, AwsError, zio.aws.applicationinsights.model.LogFilter] =
      AwsError.unwrapOptionField("logFilter", logFilter)
    def getMetricNamespace: ZIO[Any, AwsError, MetricNamespace] =
      AwsError.unwrapOptionField("metricNamespace", metricNamespace)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getUnit: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.primitives.Unit
    ] = AwsError.unwrapOptionField("unit", unit)
    def getValue: ZIO[Any, AwsError, Value] =
      AwsError.unwrapOptionField("value", value)
    def getCloudWatchEventId: ZIO[Any, AwsError, CloudWatchEventId] =
      AwsError.unwrapOptionField("cloudWatchEventId", cloudWatchEventId)
    def getCloudWatchEventSource: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.CloudWatchEventSource
    ] =
      AwsError.unwrapOptionField("cloudWatchEventSource", cloudWatchEventSource)
    def getCloudWatchEventDetailType
        : ZIO[Any, AwsError, CloudWatchEventDetailType] = AwsError
      .unwrapOptionField("cloudWatchEventDetailType", cloudWatchEventDetailType)
    def getHealthEventArn: ZIO[Any, AwsError, HealthEventArn] =
      AwsError.unwrapOptionField("healthEventArn", healthEventArn)
    def getHealthService: ZIO[Any, AwsError, HealthService] =
      AwsError.unwrapOptionField("healthService", healthService)
    def getHealthEventTypeCode: ZIO[Any, AwsError, HealthEventTypeCode] =
      AwsError.unwrapOptionField("healthEventTypeCode", healthEventTypeCode)
    def getHealthEventTypeCategory
        : ZIO[Any, AwsError, HealthEventTypeCategory] = AwsError
      .unwrapOptionField("healthEventTypeCategory", healthEventTypeCategory)
    def getHealthEventDescription: ZIO[Any, AwsError, HealthEventDescription] =
      AwsError.unwrapOptionField(
        "healthEventDescription",
        healthEventDescription
      )
    def getCodeDeployDeploymentId: ZIO[Any, AwsError, CodeDeployDeploymentId] =
      AwsError.unwrapOptionField(
        "codeDeployDeploymentId",
        codeDeployDeploymentId
      )
    def getCodeDeployDeploymentGroup
        : ZIO[Any, AwsError, CodeDeployDeploymentGroup] = AwsError
      .unwrapOptionField("codeDeployDeploymentGroup", codeDeployDeploymentGroup)
    def getCodeDeployState: ZIO[Any, AwsError, CodeDeployState] =
      AwsError.unwrapOptionField("codeDeployState", codeDeployState)
    def getCodeDeployApplication: ZIO[Any, AwsError, CodeDeployApplication] =
      AwsError.unwrapOptionField("codeDeployApplication", codeDeployApplication)
    def getCodeDeployInstanceGroupId
        : ZIO[Any, AwsError, CodeDeployInstanceGroupId] = AwsError
      .unwrapOptionField("codeDeployInstanceGroupId", codeDeployInstanceGroupId)
    def getEc2State: ZIO[Any, AwsError, Ec2State] =
      AwsError.unwrapOptionField("ec2State", ec2State)
    def getRdsEventCategories: ZIO[Any, AwsError, RdsEventCategories] =
      AwsError.unwrapOptionField("rdsEventCategories", rdsEventCategories)
    def getRdsEventMessage: ZIO[Any, AwsError, RdsEventMessage] =
      AwsError.unwrapOptionField("rdsEventMessage", rdsEventMessage)
    def getS3EventName: ZIO[Any, AwsError, S3EventName] =
      AwsError.unwrapOptionField("s3EventName", s3EventName)
    def getStatesExecutionArn: ZIO[Any, AwsError, StatesExecutionArn] =
      AwsError.unwrapOptionField("statesExecutionArn", statesExecutionArn)
    def getStatesArn: ZIO[Any, AwsError, StatesArn] =
      AwsError.unwrapOptionField("statesArn", statesArn)
    def getStatesStatus: ZIO[Any, AwsError, StatesStatus] =
      AwsError.unwrapOptionField("statesStatus", statesStatus)
    def getStatesInput: ZIO[Any, AwsError, StatesInput] =
      AwsError.unwrapOptionField("statesInput", statesInput)
    def getEbsEvent: ZIO[Any, AwsError, EbsEvent] =
      AwsError.unwrapOptionField("ebsEvent", ebsEvent)
    def getEbsResult: ZIO[Any, AwsError, EbsResult] =
      AwsError.unwrapOptionField("ebsResult", ebsResult)
    def getEbsCause: ZIO[Any, AwsError, EbsCause] =
      AwsError.unwrapOptionField("ebsCause", ebsCause)
    def getEbsRequestId: ZIO[Any, AwsError, EbsRequestId] =
      AwsError.unwrapOptionField("ebsRequestId", ebsRequestId)
    def getXRayFaultPercent: ZIO[Any, AwsError, XRayFaultPercent] =
      AwsError.unwrapOptionField("xRayFaultPercent", xRayFaultPercent)
    def getXRayThrottlePercent: ZIO[Any, AwsError, XRayThrottlePercent] =
      AwsError.unwrapOptionField("xRayThrottlePercent", xRayThrottlePercent)
    def getXRayErrorPercent: ZIO[Any, AwsError, XRayErrorPercent] =
      AwsError.unwrapOptionField("xRayErrorPercent", xRayErrorPercent)
    def getXRayRequestCount: ZIO[Any, AwsError, XRayRequestCount] =
      AwsError.unwrapOptionField("xRayRequestCount", xRayRequestCount)
    def getXRayRequestAverageLatency
        : ZIO[Any, AwsError, XRayRequestAverageLatency] = AwsError
      .unwrapOptionField("xRayRequestAverageLatency", xRayRequestAverageLatency)
    def getXRayNodeName: ZIO[Any, AwsError, XRayNodeName] =
      AwsError.unwrapOptionField("xRayNodeName", xRayNodeName)
    def getXRayNodeType: ZIO[Any, AwsError, XRayNodeType] =
      AwsError.unwrapOptionField("xRayNodeType", xRayNodeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.Observation
  ) extends zio.aws.applicationinsights.model.Observation.ReadOnly {
    override val id: Optional[ObservationId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ObservationId(value)
      )
    override val startTime: Optional[StartTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.StartTime(value)
      )
    override val endTime: Optional[EndTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.applicationinsights.model.primitives.EndTime(value))
    override val sourceType: Optional[SourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceType())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.SourceType(value)
      )
    override val sourceARN: Optional[SourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceARN())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.SourceARN(value)
      )
    override val logGroup: Optional[LogGroup] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroup())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LogGroup(value)
      )
    override val lineTime: Optional[LineTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lineTime())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LineTime(value)
      )
    override val logText: Optional[LogText] = zio.aws.core.internal
      .optionalFromNullable(impl.logText())
      .map(value => zio.aws.applicationinsights.model.primitives.LogText(value))
    override val logFilter
        : Optional[zio.aws.applicationinsights.model.LogFilter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logFilter())
        .map(value => zio.aws.applicationinsights.model.LogFilter.wrap(value))
    override val metricNamespace: Optional[MetricNamespace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricNamespace())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.MetricNamespace(value)
        )
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.MetricName(value)
      )
    override val unit
        : Optional[zio.aws.applicationinsights.model.primitives.Unit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.applicationinsights.model.primitives.Unit(value))
    override val value: Optional[Value] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.applicationinsights.model.primitives.Value(value))
    override val cloudWatchEventId: Optional[CloudWatchEventId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchEventId())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.CloudWatchEventId(value)
        )
    override val cloudWatchEventSource
        : Optional[zio.aws.applicationinsights.model.CloudWatchEventSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchEventSource())
        .map(value =>
          zio.aws.applicationinsights.model.CloudWatchEventSource.wrap(value)
        )
    override val cloudWatchEventDetailType
        : Optional[CloudWatchEventDetailType] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchEventDetailType())
      .map(value =>
        zio.aws.applicationinsights.model.primitives
          .CloudWatchEventDetailType(value)
      )
    override val healthEventArn: Optional[HealthEventArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthEventArn())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.HealthEventArn(value)
        )
    override val healthService: Optional[HealthService] = zio.aws.core.internal
      .optionalFromNullable(impl.healthService())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.HealthService(value)
      )
    override val healthEventTypeCode: Optional[HealthEventTypeCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthEventTypeCode())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .HealthEventTypeCode(value)
        )
    override val healthEventTypeCategory: Optional[HealthEventTypeCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthEventTypeCategory())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .HealthEventTypeCategory(value)
        )
    override val healthEventDescription: Optional[HealthEventDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthEventDescription())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .HealthEventDescription(value)
        )
    override val codeDeployDeploymentId: Optional[CodeDeployDeploymentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeDeployDeploymentId())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .CodeDeployDeploymentId(value)
        )
    override val codeDeployDeploymentGroup
        : Optional[CodeDeployDeploymentGroup] = zio.aws.core.internal
      .optionalFromNullable(impl.codeDeployDeploymentGroup())
      .map(value =>
        zio.aws.applicationinsights.model.primitives
          .CodeDeployDeploymentGroup(value)
      )
    override val codeDeployState: Optional[CodeDeployState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeDeployState())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.CodeDeployState(value)
        )
    override val codeDeployApplication: Optional[CodeDeployApplication] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeDeployApplication())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .CodeDeployApplication(value)
        )
    override val codeDeployInstanceGroupId
        : Optional[CodeDeployInstanceGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.codeDeployInstanceGroupId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives
          .CodeDeployInstanceGroupId(value)
      )
    override val ec2State: Optional[Ec2State] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2State())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.Ec2State(value)
      )
    override val rdsEventCategories: Optional[RdsEventCategories] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rdsEventCategories())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.RdsEventCategories(value)
        )
    override val rdsEventMessage: Optional[RdsEventMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rdsEventMessage())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.RdsEventMessage(value)
        )
    override val s3EventName: Optional[S3EventName] = zio.aws.core.internal
      .optionalFromNullable(impl.s3EventName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.S3EventName(value)
      )
    override val statesExecutionArn: Optional[StatesExecutionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statesExecutionArn())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.StatesExecutionArn(value)
        )
    override val statesArn: Optional[StatesArn] = zio.aws.core.internal
      .optionalFromNullable(impl.statesArn())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.StatesArn(value)
      )
    override val statesStatus: Optional[StatesStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.statesStatus())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.StatesStatus(value)
      )
    override val statesInput: Optional[StatesInput] = zio.aws.core.internal
      .optionalFromNullable(impl.statesInput())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.StatesInput(value)
      )
    override val ebsEvent: Optional[EbsEvent] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsEvent())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.EbsEvent(value)
      )
    override val ebsResult: Optional[EbsResult] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsResult())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.EbsResult(value)
      )
    override val ebsCause: Optional[EbsCause] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsCause())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.EbsCause(value)
      )
    override val ebsRequestId: Optional[EbsRequestId] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsRequestId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.EbsRequestId(value)
      )
    override val xRayFaultPercent: Optional[XRayFaultPercent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.xRayFaultPercent())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.XRayFaultPercent(value)
        )
    override val xRayThrottlePercent: Optional[XRayThrottlePercent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.xRayThrottlePercent())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .XRayThrottlePercent(value)
        )
    override val xRayErrorPercent: Optional[XRayErrorPercent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.xRayErrorPercent())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.XRayErrorPercent(value)
        )
    override val xRayRequestCount: Optional[XRayRequestCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.xRayRequestCount())
        .map(value =>
          zio.aws.applicationinsights.model.primitives.XRayRequestCount(value)
        )
    override val xRayRequestAverageLatency
        : Optional[XRayRequestAverageLatency] = zio.aws.core.internal
      .optionalFromNullable(impl.xRayRequestAverageLatency())
      .map(value =>
        zio.aws.applicationinsights.model.primitives
          .XRayRequestAverageLatency(value)
      )
    override val xRayNodeName: Optional[XRayNodeName] = zio.aws.core.internal
      .optionalFromNullable(impl.xRayNodeName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.XRayNodeName(value)
      )
    override val xRayNodeType: Optional[XRayNodeType] = zio.aws.core.internal
      .optionalFromNullable(impl.xRayNodeType())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.XRayNodeType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.Observation
  ): zio.aws.applicationinsights.model.Observation.ReadOnly = new Wrapper(impl)
}
