package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.ResourceGroupName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateLogPatternResponse(
    logPattern: Option[zio.aws.applicationinsights.model.LogPattern] = None,
    resourceGroupName: Option[ResourceGroupName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternResponse = {
    import CreateLogPatternResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternResponse
      .builder()
      .optionallyWith(logPattern.map(value => value.buildAwsValue()))(
        _.logPattern
      )
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.CreateLogPatternResponse.ReadOnly =
    zio.aws.applicationinsights.model.CreateLogPatternResponse
      .wrap(buildAwsValue())
}
object CreateLogPatternResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.CreateLogPatternResponse =
      zio.aws.applicationinsights.model.CreateLogPatternResponse(
        logPattern.map(value => value.asEditable),
        resourceGroupName.map(value => value)
      )
    def logPattern
        : Option[zio.aws.applicationinsights.model.LogPattern.ReadOnly]
    def resourceGroupName: Option[ResourceGroupName]
    def getLogPattern: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.LogPattern.ReadOnly
    ] = AwsError.unwrapOptionField("logPattern", logPattern)
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternResponse
  ) extends zio.aws.applicationinsights.model.CreateLogPatternResponse.ReadOnly {
    override val logPattern
        : Option[zio.aws.applicationinsights.model.LogPattern.ReadOnly] = scala
      .Option(impl.logPattern())
      .map(value => zio.aws.applicationinsights.model.LogPattern.wrap(value))
    override val resourceGroupName: Option[ResourceGroupName] = scala
      .Option(impl.resourceGroupName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternResponse
  ): zio.aws.applicationinsights.model.CreateLogPatternResponse.ReadOnly =
    new Wrapper(impl)
}
