package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.ResourceGroupName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateLogPatternResponse(
    resourceGroupName: Option[ResourceGroupName] = None,
    logPattern: Option[zio.aws.applicationinsights.model.LogPattern] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.UpdateLogPatternResponse = {
    import UpdateLogPatternResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.UpdateLogPatternResponse
      .builder()
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .optionallyWith(logPattern.map(value => value.buildAwsValue()))(
        _.logPattern
      )
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.UpdateLogPatternResponse.ReadOnly =
    zio.aws.applicationinsights.model.UpdateLogPatternResponse
      .wrap(buildAwsValue())
}
object UpdateLogPatternResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.UpdateLogPatternResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.UpdateLogPatternResponse =
      zio.aws.applicationinsights.model.UpdateLogPatternResponse(
        resourceGroupName.map(value => value),
        logPattern.map(value => value.asEditable)
      )
    def resourceGroupName: Option[ResourceGroupName]
    def logPattern
        : Option[zio.aws.applicationinsights.model.LogPattern.ReadOnly]
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
    def getLogPattern: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.LogPattern.ReadOnly
    ] = AwsError.unwrapOptionField("logPattern", logPattern)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateLogPatternResponse
  ) extends zio.aws.applicationinsights.model.UpdateLogPatternResponse.ReadOnly {
    override val resourceGroupName: Option[ResourceGroupName] = scala
      .Option(impl.resourceGroupName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
      )
    override val logPattern
        : Option[zio.aws.applicationinsights.model.LogPattern.ReadOnly] = scala
      .Option(impl.logPattern())
      .map(value => zio.aws.applicationinsights.model.LogPattern.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateLogPatternResponse
  ): zio.aws.applicationinsights.model.UpdateLogPatternResponse.ReadOnly =
    new Wrapper(impl)
}
