package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  Insights,
  ProblemId,
  AffectedResource,
  RecurringCount,
  EndTime,
  StartTime,
  LastRecurrenceTime,
  ResourceGroupName,
  Title
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Problem(
    id: Option[ProblemId] = None,
    title: Option[Title] = None,
    insights: Option[Insights] = None,
    status: Option[zio.aws.applicationinsights.model.Status] = None,
    affectedResource: Option[AffectedResource] = None,
    startTime: Option[StartTime] = None,
    endTime: Option[EndTime] = None,
    severityLevel: Option[zio.aws.applicationinsights.model.SeverityLevel] =
      None,
    resourceGroupName: Option[ResourceGroupName] = None,
    feedback: Option[Map[
      zio.aws.applicationinsights.model.FeedbackKey,
      zio.aws.applicationinsights.model.FeedbackValue
    ]] = None,
    recurringCount: Option[RecurringCount] = None,
    lastRecurrenceTime: Option[LastRecurrenceTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.Problem = {
    import Problem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.Problem
      .builder()
      .optionallyWith(
        id.map(value => ProblemId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        title.map(value => Title.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        insights.map(value => Insights.unwrap(value): java.lang.String)
      )(_.insights)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        affectedResource.map(value =>
          AffectedResource.unwrap(value): java.lang.String
        )
      )(_.affectedResource)
      .optionallyWith(startTime.map(value => StartTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => EndTime.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(severityLevel.map(value => value.unwrap))(_.severityLevel)
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .optionallyWith(
        feedback.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.unwrap.toString
            })
            .asJava
        )
      )(_.feedbackWithStrings)
      .optionallyWith(
        recurringCount.map(value =>
          RecurringCount.unwrap(value): java.lang.Long
        )
      )(_.recurringCount)
      .optionallyWith(
        lastRecurrenceTime.map(value =>
          LastRecurrenceTime.unwrap(value): Instant
        )
      )(_.lastRecurrenceTime)
      .build()
  }
  def asReadOnly: zio.aws.applicationinsights.model.Problem.ReadOnly =
    zio.aws.applicationinsights.model.Problem.wrap(buildAwsValue())
}
object Problem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.Problem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.Problem =
      zio.aws.applicationinsights.model.Problem(
        id.map(value => value),
        title.map(value => value),
        insights.map(value => value),
        status.map(value => value),
        affectedResource.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        severityLevel.map(value => value),
        resourceGroupName.map(value => value),
        feedback.map(value => value),
        recurringCount.map(value => value),
        lastRecurrenceTime.map(value => value)
      )
    def id: Option[ProblemId]
    def title: Option[Title]
    def insights: Option[Insights]
    def status: Option[zio.aws.applicationinsights.model.Status]
    def affectedResource: Option[AffectedResource]
    def startTime: Option[StartTime]
    def endTime: Option[EndTime]
    def severityLevel: Option[zio.aws.applicationinsights.model.SeverityLevel]
    def resourceGroupName: Option[ResourceGroupName]
    def feedback: Option[Map[
      zio.aws.applicationinsights.model.FeedbackKey,
      zio.aws.applicationinsights.model.FeedbackValue
    ]]
    def recurringCount: Option[RecurringCount]
    def lastRecurrenceTime: Option[LastRecurrenceTime]
    def getId: ZIO[Any, AwsError, ProblemId] =
      AwsError.unwrapOptionField("id", id)
    def getTitle: ZIO[Any, AwsError, Title] =
      AwsError.unwrapOptionField("title", title)
    def getInsights: ZIO[Any, AwsError, Insights] =
      AwsError.unwrapOptionField("insights", insights)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.applicationinsights.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getAffectedResource: ZIO[Any, AwsError, AffectedResource] =
      AwsError.unwrapOptionField("affectedResource", affectedResource)
    def getStartTime: ZIO[Any, AwsError, StartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, EndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getSeverityLevel
        : ZIO[Any, AwsError, zio.aws.applicationinsights.model.SeverityLevel] =
      AwsError.unwrapOptionField("severityLevel", severityLevel)
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
    def getFeedback: ZIO[Any, AwsError, Map[
      zio.aws.applicationinsights.model.FeedbackKey,
      zio.aws.applicationinsights.model.FeedbackValue
    ]] = AwsError.unwrapOptionField("feedback", feedback)
    def getRecurringCount: ZIO[Any, AwsError, RecurringCount] =
      AwsError.unwrapOptionField("recurringCount", recurringCount)
    def getLastRecurrenceTime: ZIO[Any, AwsError, LastRecurrenceTime] =
      AwsError.unwrapOptionField("lastRecurrenceTime", lastRecurrenceTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.Problem
  ) extends zio.aws.applicationinsights.model.Problem.ReadOnly {
    override val id: Option[ProblemId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ProblemId(value)
      )
    override val title: Option[Title] = scala
      .Option(impl.title())
      .map(value => zio.aws.applicationinsights.model.primitives.Title(value))
    override val insights: Option[Insights] = scala
      .Option(impl.insights())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.Insights(value)
      )
    override val status: Option[zio.aws.applicationinsights.model.Status] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.applicationinsights.model.Status.wrap(value))
    override val affectedResource: Option[AffectedResource] = scala
      .Option(impl.affectedResource())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.AffectedResource(value)
      )
    override val startTime: Option[StartTime] = scala
      .Option(impl.startTime())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.StartTime(value)
      )
    override val endTime: Option[EndTime] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.applicationinsights.model.primitives.EndTime(value))
    override val severityLevel
        : Option[zio.aws.applicationinsights.model.SeverityLevel] = scala
      .Option(impl.severityLevel())
      .map(value => zio.aws.applicationinsights.model.SeverityLevel.wrap(value))
    override val resourceGroupName: Option[ResourceGroupName] = scala
      .Option(impl.resourceGroupName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
      )
    override val feedback: Option[Map[
      zio.aws.applicationinsights.model.FeedbackKey,
      zio.aws.applicationinsights.model.FeedbackValue
    ]] = scala
      .Option(impl.feedback())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.applicationinsights.model.FeedbackKey.wrap(
              key
            ) -> zio.aws.applicationinsights.model.FeedbackValue.wrap(value)
          })
          .toMap
      )
    override val recurringCount: Option[RecurringCount] = scala
      .Option(impl.recurringCount())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.RecurringCount(value)
      )
    override val lastRecurrenceTime: Option[LastRecurrenceTime] = scala
      .Option(impl.lastRecurrenceTime())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LastRecurrenceTime(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.Problem
  ): zio.aws.applicationinsights.model.Problem.ReadOnly = new Wrapper(impl)
}
