package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListComponentsResponse(
    applicationComponentList: Option[
      Iterable[zio.aws.applicationinsights.model.ApplicationComponent]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListComponentsResponse = {
    import ListComponentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListComponentsResponse
      .builder()
      .optionallyWith(
        applicationComponentList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applicationComponentList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListComponentsResponse.ReadOnly =
    zio.aws.applicationinsights.model.ListComponentsResponse
      .wrap(buildAwsValue())
}
object ListComponentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListComponentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ListComponentsResponse =
      zio.aws.applicationinsights.model.ListComponentsResponse(
        applicationComponentList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def applicationComponentList: Option[
      List[zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly]
    ]
    def nextToken: Option[PaginationToken]
    def getApplicationComponentList: ZIO[Any, AwsError, List[
      zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "applicationComponentList",
      applicationComponentList
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListComponentsResponse
  ) extends zio.aws.applicationinsights.model.ListComponentsResponse.ReadOnly {
    override val applicationComponentList: Option[
      List[zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly]
    ] = scala
      .Option(impl.applicationComponentList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationinsights.model.ApplicationComponent.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListComponentsResponse
  ): zio.aws.applicationinsights.model.ListComponentsResponse.ReadOnly =
    new Wrapper(impl)
}
