package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RelatedObservations(
    observationList: Option[
      Iterable[zio.aws.applicationinsights.model.Observation]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.RelatedObservations = {
    import RelatedObservations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.RelatedObservations
      .builder()
      .optionallyWith(
        observationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.observationList)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.RelatedObservations.ReadOnly =
    zio.aws.applicationinsights.model.RelatedObservations.wrap(buildAwsValue())
}
object RelatedObservations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.RelatedObservations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.RelatedObservations =
      zio.aws.applicationinsights.model.RelatedObservations(
        observationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def observationList
        : Option[List[zio.aws.applicationinsights.model.Observation.ReadOnly]]
    def getObservationList: ZIO[Any, AwsError, List[
      zio.aws.applicationinsights.model.Observation.ReadOnly
    ]] = AwsError.unwrapOptionField("observationList", observationList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.RelatedObservations
  ) extends zio.aws.applicationinsights.model.RelatedObservations.ReadOnly {
    override val observationList
        : Option[List[zio.aws.applicationinsights.model.Observation.ReadOnly]] =
      scala
        .Option(impl.observationList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.applicationinsights.model.Observation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.RelatedObservations
  ): zio.aws.applicationinsights.model.RelatedObservations.ReadOnly =
    new Wrapper(impl)
}
