package zio.aws.applicationinsights.model
import java.lang.Integer
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  LogPatternRank,
  LogPatternRegex,
  LogPatternName,
  LogPatternSetName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LogPattern(
    patternSetName: Option[LogPatternSetName] = None,
    patternName: Option[LogPatternName] = None,
    pattern: Option[LogPatternRegex] = None,
    rank: Option[LogPatternRank] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.LogPattern = {
    import LogPattern.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.LogPattern
      .builder()
      .optionallyWith(
        patternSetName.map(value =>
          LogPatternSetName.unwrap(value): java.lang.String
        )
      )(_.patternSetName)
      .optionallyWith(
        patternName.map(value => LogPatternName.unwrap(value): java.lang.String)
      )(_.patternName)
      .optionallyWith(
        pattern.map(value => LogPatternRegex.unwrap(value): java.lang.String)
      )(_.pattern)
      .optionallyWith(rank.map(value => LogPatternRank.unwrap(value): Integer))(
        _.rank
      )
      .build()
  }
  def asReadOnly: zio.aws.applicationinsights.model.LogPattern.ReadOnly =
    zio.aws.applicationinsights.model.LogPattern.wrap(buildAwsValue())
}
object LogPattern {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.LogPattern
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.LogPattern =
      zio.aws.applicationinsights.model.LogPattern(
        patternSetName.map(value => value),
        patternName.map(value => value),
        pattern.map(value => value),
        rank.map(value => value)
      )
    def patternSetName: Option[LogPatternSetName]
    def patternName: Option[LogPatternName]
    def pattern: Option[LogPatternRegex]
    def rank: Option[LogPatternRank]
    def getPatternSetName: ZIO[Any, AwsError, LogPatternSetName] =
      AwsError.unwrapOptionField("patternSetName", patternSetName)
    def getPatternName: ZIO[Any, AwsError, LogPatternName] =
      AwsError.unwrapOptionField("patternName", patternName)
    def getPattern: ZIO[Any, AwsError, LogPatternRegex] =
      AwsError.unwrapOptionField("pattern", pattern)
    def getRank: ZIO[Any, AwsError, LogPatternRank] =
      AwsError.unwrapOptionField("rank", rank)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.LogPattern
  ) extends zio.aws.applicationinsights.model.LogPattern.ReadOnly {
    override val patternSetName: Option[LogPatternSetName] = scala
      .Option(impl.patternSetName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LogPatternSetName(value)
      )
    override val patternName: Option[LogPatternName] = scala
      .Option(impl.patternName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LogPatternName(value)
      )
    override val pattern: Option[LogPatternRegex] = scala
      .Option(impl.pattern())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LogPatternRegex(value)
      )
    override val rank: Option[LogPatternRank] = scala
      .Option(impl.rank())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LogPatternRank(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.LogPattern
  ): zio.aws.applicationinsights.model.LogPattern.ReadOnly = new Wrapper(impl)
}
