package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  ComponentConfiguration,
  Monitor
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeComponentConfigurationResponse(
    monitor: Option[Monitor] = None,
    tier: Option[zio.aws.applicationinsights.model.Tier] = None,
    componentConfiguration: Option[ComponentConfiguration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationResponse = {
    import DescribeComponentConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationResponse
      .builder()
      .optionallyWith(
        monitor.map(value => Monitor.unwrap(value): java.lang.Boolean)
      )(_.monitor)
      .optionallyWith(tier.map(value => value.unwrap))(_.tier)
      .optionallyWith(
        componentConfiguration.map(value =>
          ComponentConfiguration.unwrap(value): java.lang.String
        )
      )(_.componentConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse.ReadOnly =
    zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeComponentConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse =
      zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse(
        monitor.map(value => value),
        tier.map(value => value),
        componentConfiguration.map(value => value)
      )
    def monitor: Option[Monitor]
    def tier: Option[zio.aws.applicationinsights.model.Tier]
    def componentConfiguration: Option[ComponentConfiguration]
    def getMonitor: ZIO[Any, AwsError, Monitor] =
      AwsError.unwrapOptionField("monitor", monitor)
    def getTier: ZIO[Any, AwsError, zio.aws.applicationinsights.model.Tier] =
      AwsError.unwrapOptionField("tier", tier)
    def getComponentConfiguration: ZIO[Any, AwsError, ComponentConfiguration] =
      AwsError.unwrapOptionField(
        "componentConfiguration",
        componentConfiguration
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationResponse
  ) extends zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse.ReadOnly {
    override val monitor: Option[Monitor] = scala
      .Option(impl.monitor())
      .map(value => zio.aws.applicationinsights.model.primitives.Monitor(value))
    override val tier: Option[zio.aws.applicationinsights.model.Tier] = scala
      .Option(impl.tier())
      .map(value => zio.aws.applicationinsights.model.Tier.wrap(value))
    override val componentConfiguration: Option[ComponentConfiguration] = scala
      .Option(impl.componentConfiguration())
      .map(value =>
        zio.aws.applicationinsights.model.primitives
          .ComponentConfiguration(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationResponse
  ): zio.aws.applicationinsights.model.DescribeComponentConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
