package zio.aws.applicationinsights.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.applicationinsights.model.primitives.{
  MaxEntities,
  ComponentName,
  EndTime,
  StartTime,
  PaginationToken,
  ResourceGroupName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListProblemsRequest(
    resourceGroupName: Option[ResourceGroupName] = None,
    startTime: Option[StartTime] = None,
    endTime: Option[EndTime] = None,
    maxResults: Option[MaxEntities] = None,
    nextToken: Option[PaginationToken] = None,
    componentName: Option[ComponentName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListProblemsRequest = {
    import ListProblemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListProblemsRequest
      .builder()
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .optionallyWith(startTime.map(value => StartTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => EndTime.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        maxResults.map(value => MaxEntities.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        componentName.map(value =>
          ComponentName.unwrap(value): java.lang.String
        )
      )(_.componentName)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListProblemsRequest.ReadOnly =
    zio.aws.applicationinsights.model.ListProblemsRequest.wrap(buildAwsValue())
}
object ListProblemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListProblemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ListProblemsRequest =
      zio.aws.applicationinsights.model.ListProblemsRequest(
        resourceGroupName.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        componentName.map(value => value)
      )
    def resourceGroupName: Option[ResourceGroupName]
    def startTime: Option[StartTime]
    def endTime: Option[EndTime]
    def maxResults: Option[MaxEntities]
    def nextToken: Option[PaginationToken]
    def componentName: Option[ComponentName]
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
    def getStartTime: ZIO[Any, AwsError, StartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, EndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getMaxResults: ZIO[Any, AwsError, MaxEntities] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getComponentName: ZIO[Any, AwsError, ComponentName] =
      AwsError.unwrapOptionField("componentName", componentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListProblemsRequest
  ) extends zio.aws.applicationinsights.model.ListProblemsRequest.ReadOnly {
    override val resourceGroupName: Option[ResourceGroupName] = scala
      .Option(impl.resourceGroupName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
      )
    override val startTime: Option[StartTime] = scala
      .Option(impl.startTime())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.StartTime(value)
      )
    override val endTime: Option[EndTime] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.applicationinsights.model.primitives.EndTime(value))
    override val maxResults: Option[MaxEntities] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.MaxEntities(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.PaginationToken(value)
      )
    override val componentName: Option[ComponentName] = scala
      .Option(impl.componentName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ComponentName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListProblemsRequest
  ): zio.aws.applicationinsights.model.ListProblemsRequest.ReadOnly =
    new Wrapper(impl)
}
