package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.ResourceARN
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeComponentResponse(
    applicationComponent: Option[
      zio.aws.applicationinsights.model.ApplicationComponent
    ] = None,
    resourceList: Option[Iterable[ResourceARN]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeComponentResponse = {
    import DescribeComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentResponse
      .builder()
      .optionallyWith(applicationComponent.map(value => value.buildAwsValue()))(
        _.applicationComponent
      )
      .optionallyWith(
        resourceList.map(value =>
          value.map { item =>
            ResourceARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceList)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeComponentResponse.ReadOnly =
    zio.aws.applicationinsights.model.DescribeComponentResponse
      .wrap(buildAwsValue())
}
object DescribeComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeComponentResponse =
      zio.aws.applicationinsights.model.DescribeComponentResponse(
        applicationComponent.map(value => value.asEditable),
        resourceList.map(value => value)
      )
    def applicationComponent: Option[
      zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly
    ]
    def resourceList: Option[List[ResourceARN]]
    def getApplicationComponent: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly
    ] = AwsError.unwrapOptionField("applicationComponent", applicationComponent)
    def getResourceList: ZIO[Any, AwsError, List[ResourceARN]] =
      AwsError.unwrapOptionField("resourceList", resourceList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentResponse
  ) extends zio.aws.applicationinsights.model.DescribeComponentResponse.ReadOnly {
    override val applicationComponent: Option[
      zio.aws.applicationinsights.model.ApplicationComponent.ReadOnly
    ] = scala
      .Option(impl.applicationComponent())
      .map(value =>
        zio.aws.applicationinsights.model.ApplicationComponent.wrap(value)
      )
    override val resourceList: Option[List[ResourceARN]] = scala
      .Option(impl.resourceList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationinsights.model.primitives.ResourceARN(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentResponse
  ): zio.aws.applicationinsights.model.DescribeComponentResponse.ReadOnly =
    new Wrapper(impl)
}
