package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  PaginationToken,
  ResourceGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListLogPatternsResponse(
    resourceGroupName: Option[ResourceGroupName] = None,
    logPatterns: Option[
      Iterable[zio.aws.applicationinsights.model.LogPattern]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsResponse = {
    import ListLogPatternsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsResponse
      .builder()
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .optionallyWith(
        logPatterns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logPatterns)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListLogPatternsResponse.ReadOnly =
    zio.aws.applicationinsights.model.ListLogPatternsResponse
      .wrap(buildAwsValue())
}
object ListLogPatternsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ListLogPatternsResponse =
      zio.aws.applicationinsights.model.ListLogPatternsResponse(
        resourceGroupName.map(value => value),
        logPatterns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resourceGroupName: Option[ResourceGroupName]
    def logPatterns
        : Option[List[zio.aws.applicationinsights.model.LogPattern.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
    def getLogPatterns: ZIO[Any, AwsError, List[
      zio.aws.applicationinsights.model.LogPattern.ReadOnly
    ]] = AwsError.unwrapOptionField("logPatterns", logPatterns)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsResponse
  ) extends zio.aws.applicationinsights.model.ListLogPatternsResponse.ReadOnly {
    override val resourceGroupName: Option[ResourceGroupName] = scala
      .Option(impl.resourceGroupName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
      )
    override val logPatterns
        : Option[List[zio.aws.applicationinsights.model.LogPattern.ReadOnly]] =
      scala
        .Option(impl.logPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.applicationinsights.model.LogPattern.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsResponse
  ): zio.aws.applicationinsights.model.ListLogPatternsResponse.ReadOnly =
    new Wrapper(impl)
}
