package zio.aws.applicationinsights.model
import scala.jdk.CollectionConverters._
sealed trait FeedbackKey {
  def unwrap
      : software.amazon.awssdk.services.applicationinsights.model.FeedbackKey
}
object FeedbackKey {
  def wrap(
      value: software.amazon.awssdk.services.applicationinsights.model.FeedbackKey
  ): zio.aws.applicationinsights.model.FeedbackKey = value match {
    case software.amazon.awssdk.services.applicationinsights.model.FeedbackKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationinsights.model.FeedbackKey.INSIGHTS_FEEDBACK =>
      val r = INSIGHTS_FEEDBACK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationinsights.model.FeedbackKey {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.FeedbackKey =
      software.amazon.awssdk.services.applicationinsights.model.FeedbackKey.UNKNOWN_TO_SDK_VERSION
  }
  case object INSIGHTS_FEEDBACK
      extends zio.aws.applicationinsights.model.FeedbackKey {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.FeedbackKey =
      software.amazon.awssdk.services.applicationinsights.model.FeedbackKey.INSIGHTS_FEEDBACK
  }
}
