package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeProblemResponse(
    problem: Option[zio.aws.applicationinsights.model.Problem] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeProblemResponse = {
    import DescribeProblemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeProblemResponse
      .builder()
      .optionallyWith(problem.map(value => value.buildAwsValue()))(_.problem)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeProblemResponse.ReadOnly =
    zio.aws.applicationinsights.model.DescribeProblemResponse
      .wrap(buildAwsValue())
}
object DescribeProblemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeProblemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.DescribeProblemResponse =
      zio.aws.applicationinsights.model
        .DescribeProblemResponse(problem.map(value => value.asEditable))
    def problem: Option[zio.aws.applicationinsights.model.Problem.ReadOnly]
    def getProblem: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.Problem.ReadOnly
    ] = AwsError.unwrapOptionField("problem", problem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeProblemResponse
  ) extends zio.aws.applicationinsights.model.DescribeProblemResponse.ReadOnly {
    override val problem
        : Option[zio.aws.applicationinsights.model.Problem.ReadOnly] = scala
      .Option(impl.problem())
      .map(value => zio.aws.applicationinsights.model.Problem.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeProblemResponse
  ): zio.aws.applicationinsights.model.DescribeProblemResponse.ReadOnly =
    new Wrapper(impl)
}
