package zio.aws.applicationinsights.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.applicationinsights.model.primitives.{
  CodeDeployInstanceGroupId,
  MetricName,
  RdsEventMessage,
  XRayRequestAverageLatency,
  MetricNamespace,
  XRayRequestCount,
  LineTime,
  StatesInput,
  XRayNodeType,
  EbsCause,
  EbsRequestId,
  CodeDeployApplication,
  SourceType,
  S3EventName,
  CodeDeployDeploymentId,
  XRayErrorPercent,
  HealthEventArn,
  XRayThrottlePercent,
  RdsEventCategories,
  CodeDeployDeploymentGroup,
  EbsEvent,
  StatesExecutionArn,
  EndTime,
  StartTime,
  Value,
  HealthEventTypeCode,
  LogGroup,
  CloudWatchEventDetailType,
  SourceARN,
  Ec2State,
  ObservationId,
  EbsResult,
  CodeDeployState,
  LogText,
  XRayNodeName,
  StatesStatus,
  HealthEventDescription,
  XRayFaultPercent,
  HealthService,
  CloudWatchEventId,
  StatesArn,
  HealthEventTypeCategory
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Observation(
    id: Option[ObservationId] = None,
    startTime: Option[StartTime] = None,
    endTime: Option[EndTime] = None,
    sourceType: Option[SourceType] = None,
    sourceARN: Option[SourceARN] = None,
    logGroup: Option[LogGroup] = None,
    lineTime: Option[LineTime] = None,
    logText: Option[LogText] = None,
    logFilter: Option[zio.aws.applicationinsights.model.LogFilter] = None,
    metricNamespace: Option[MetricNamespace] = None,
    metricName: Option[MetricName] = None,
    unit: Option[zio.aws.applicationinsights.model.primitives.Unit] = None,
    value: Option[Value] = None,
    cloudWatchEventId: Option[CloudWatchEventId] = None,
    cloudWatchEventSource: Option[
      zio.aws.applicationinsights.model.CloudWatchEventSource
    ] = None,
    cloudWatchEventDetailType: Option[CloudWatchEventDetailType] = None,
    healthEventArn: Option[HealthEventArn] = None,
    healthService: Option[HealthService] = None,
    healthEventTypeCode: Option[HealthEventTypeCode] = None,
    healthEventTypeCategory: Option[HealthEventTypeCategory] = None,
    healthEventDescription: Option[HealthEventDescription] = None,
    codeDeployDeploymentId: Option[CodeDeployDeploymentId] = None,
    codeDeployDeploymentGroup: Option[CodeDeployDeploymentGroup] = None,
    codeDeployState: Option[CodeDeployState] = None,
    codeDeployApplication: Option[CodeDeployApplication] = None,
    codeDeployInstanceGroupId: Option[CodeDeployInstanceGroupId] = None,
    ec2State: Option[Ec2State] = None,
    rdsEventCategories: Option[RdsEventCategories] = None,
    rdsEventMessage: Option[RdsEventMessage] = None,
    s3EventName: Option[S3EventName] = None,
    statesExecutionArn: Option[StatesExecutionArn] = None,
    statesArn: Option[StatesArn] = None,
    statesStatus: Option[StatesStatus] = None,
    statesInput: Option[StatesInput] = None,
    ebsEvent: Option[EbsEvent] = None,
    ebsResult: Option[EbsResult] = None,
    ebsCause: Option[EbsCause] = None,
    ebsRequestId: Option[EbsRequestId] = None,
    xRayFaultPercent: Option[XRayFaultPercent] = None,
    xRayThrottlePercent: Option[XRayThrottlePercent] = None,
    xRayErrorPercent: Option[XRayErrorPercent] = None,
    xRayRequestCount: Option[XRayRequestCount] = None,
    xRayRequestAverageLatency: Option[XRayRequestAverageLatency] = None,
    xRayNodeName: Option[XRayNodeName] = None,
    xRayNodeType: Option[XRayNodeType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.Observation = {
    import Observation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.Observation
      .builder()
      .optionallyWith(
        id.map(value => ObservationId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(startTime.map(value => StartTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => EndTime.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        sourceType.map(value => SourceType.unwrap(value): java.lang.String)
      )(_.sourceType)
      .optionallyWith(
        sourceARN.map(value => SourceARN.unwrap(value): java.lang.String)
      )(_.sourceARN)
      .optionallyWith(
        logGroup.map(value => LogGroup.unwrap(value): java.lang.String)
      )(_.logGroup)
      .optionallyWith(lineTime.map(value => LineTime.unwrap(value): Instant))(
        _.lineTime
      )
      .optionallyWith(
        logText.map(value => LogText.unwrap(value): java.lang.String)
      )(_.logText)
      .optionallyWith(logFilter.map(value => value.unwrap))(_.logFilter)
      .optionallyWith(
        metricNamespace.map(value =>
          MetricNamespace.unwrap(value): java.lang.String
        )
      )(_.metricNamespace)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        unit.map(value =>
          zio.aws.applicationinsights.model.primitives.Unit.unwrap(
            value
          ): java.lang.String
        )
      )(_.unit)
      .optionallyWith(
        value.map(value => Value.unwrap(value): java.lang.Double)
      )(_.value)
      .optionallyWith(
        cloudWatchEventId.map(value =>
          CloudWatchEventId.unwrap(value): java.lang.String
        )
      )(_.cloudWatchEventId)
      .optionallyWith(cloudWatchEventSource.map(value => value.unwrap))(
        _.cloudWatchEventSource
      )
      .optionallyWith(
        cloudWatchEventDetailType.map(value =>
          CloudWatchEventDetailType.unwrap(value): java.lang.String
        )
      )(_.cloudWatchEventDetailType)
      .optionallyWith(
        healthEventArn.map(value =>
          HealthEventArn.unwrap(value): java.lang.String
        )
      )(_.healthEventArn)
      .optionallyWith(
        healthService.map(value =>
          HealthService.unwrap(value): java.lang.String
        )
      )(_.healthService)
      .optionallyWith(
        healthEventTypeCode.map(value =>
          HealthEventTypeCode.unwrap(value): java.lang.String
        )
      )(_.healthEventTypeCode)
      .optionallyWith(
        healthEventTypeCategory.map(value =>
          HealthEventTypeCategory.unwrap(value): java.lang.String
        )
      )(_.healthEventTypeCategory)
      .optionallyWith(
        healthEventDescription.map(value =>
          HealthEventDescription.unwrap(value): java.lang.String
        )
      )(_.healthEventDescription)
      .optionallyWith(
        codeDeployDeploymentId.map(value =>
          CodeDeployDeploymentId.unwrap(value): java.lang.String
        )
      )(_.codeDeployDeploymentId)
      .optionallyWith(
        codeDeployDeploymentGroup.map(value =>
          CodeDeployDeploymentGroup.unwrap(value): java.lang.String
        )
      )(_.codeDeployDeploymentGroup)
      .optionallyWith(
        codeDeployState.map(value =>
          CodeDeployState.unwrap(value): java.lang.String
        )
      )(_.codeDeployState)
      .optionallyWith(
        codeDeployApplication.map(value =>
          CodeDeployApplication.unwrap(value): java.lang.String
        )
      )(_.codeDeployApplication)
      .optionallyWith(
        codeDeployInstanceGroupId.map(value =>
          CodeDeployInstanceGroupId.unwrap(value): java.lang.String
        )
      )(_.codeDeployInstanceGroupId)
      .optionallyWith(
        ec2State.map(value => Ec2State.unwrap(value): java.lang.String)
      )(_.ec2State)
      .optionallyWith(
        rdsEventCategories.map(value =>
          RdsEventCategories.unwrap(value): java.lang.String
        )
      )(_.rdsEventCategories)
      .optionallyWith(
        rdsEventMessage.map(value =>
          RdsEventMessage.unwrap(value): java.lang.String
        )
      )(_.rdsEventMessage)
      .optionallyWith(
        s3EventName.map(value => S3EventName.unwrap(value): java.lang.String)
      )(_.s3EventName)
      .optionallyWith(
        statesExecutionArn.map(value =>
          StatesExecutionArn.unwrap(value): java.lang.String
        )
      )(_.statesExecutionArn)
      .optionallyWith(
        statesArn.map(value => StatesArn.unwrap(value): java.lang.String)
      )(_.statesArn)
      .optionallyWith(
        statesStatus.map(value => StatesStatus.unwrap(value): java.lang.String)
      )(_.statesStatus)
      .optionallyWith(
        statesInput.map(value => StatesInput.unwrap(value): java.lang.String)
      )(_.statesInput)
      .optionallyWith(
        ebsEvent.map(value => EbsEvent.unwrap(value): java.lang.String)
      )(_.ebsEvent)
      .optionallyWith(
        ebsResult.map(value => EbsResult.unwrap(value): java.lang.String)
      )(_.ebsResult)
      .optionallyWith(
        ebsCause.map(value => EbsCause.unwrap(value): java.lang.String)
      )(_.ebsCause)
      .optionallyWith(
        ebsRequestId.map(value => EbsRequestId.unwrap(value): java.lang.String)
      )(_.ebsRequestId)
      .optionallyWith(
        xRayFaultPercent.map(value => XRayFaultPercent.unwrap(value): Integer)
      )(_.xRayFaultPercent)
      .optionallyWith(
        xRayThrottlePercent.map(value =>
          XRayThrottlePercent.unwrap(value): Integer
        )
      )(_.xRayThrottlePercent)
      .optionallyWith(
        xRayErrorPercent.map(value => XRayErrorPercent.unwrap(value): Integer)
      )(_.xRayErrorPercent)
      .optionallyWith(
        xRayRequestCount.map(value => XRayRequestCount.unwrap(value): Integer)
      )(_.xRayRequestCount)
      .optionallyWith(
        xRayRequestAverageLatency.map(value =>
          XRayRequestAverageLatency.unwrap(value): java.lang.Long
        )
      )(_.xRayRequestAverageLatency)
      .optionallyWith(
        xRayNodeName.map(value => XRayNodeName.unwrap(value): java.lang.String)
      )(_.xRayNodeName)
      .optionallyWith(
        xRayNodeType.map(value => XRayNodeType.unwrap(value): java.lang.String)
      )(_.xRayNodeType)
      .build()
  }
  def asReadOnly: zio.aws.applicationinsights.model.Observation.ReadOnly =
    zio.aws.applicationinsights.model.Observation.wrap(buildAwsValue())
}
object Observation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.Observation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.Observation =
      zio.aws.applicationinsights.model.Observation(
        id.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        sourceType.map(value => value),
        sourceARN.map(value => value),
        logGroup.map(value => value),
        lineTime.map(value => value),
        logText.map(value => value),
        logFilter.map(value => value),
        metricNamespace.map(value => value),
        metricName.map(value => value),
        unit.map(value => value),
        value.map(value => value),
        cloudWatchEventId.map(value => value),
        cloudWatchEventSource.map(value => value),
        cloudWatchEventDetailType.map(value => value),
        healthEventArn.map(value => value),
        healthService.map(value => value),
        healthEventTypeCode.map(value => value),
        healthEventTypeCategory.map(value => value),
        healthEventDescription.map(value => value),
        codeDeployDeploymentId.map(value => value),
        codeDeployDeploymentGroup.map(value => value),
        codeDeployState.map(value => value),
        codeDeployApplication.map(value => value),
        codeDeployInstanceGroupId.map(value => value),
        ec2State.map(value => value),
        rdsEventCategories.map(value => value),
        rdsEventMessage.map(value => value),
        s3EventName.map(value => value),
        statesExecutionArn.map(value => value),
        statesArn.map(value => value),
        statesStatus.map(value => value),
        statesInput.map(value => value),
        ebsEvent.map(value => value),
        ebsResult.map(value => value),
        ebsCause.map(value => value),
        ebsRequestId.map(value => value),
        xRayFaultPercent.map(value => value),
        xRayThrottlePercent.map(value => value),
        xRayErrorPercent.map(value => value),
        xRayRequestCount.map(value => value),
        xRayRequestAverageLatency.map(value => value),
        xRayNodeName.map(value => value),
        xRayNodeType.map(value => value)
      )
    def id: Option[ObservationId]
    def startTime: Option[StartTime]
    def endTime: Option[EndTime]
    def sourceType: Option[SourceType]
    def sourceARN: Option[SourceARN]
    def logGroup: Option[LogGroup]
    def lineTime: Option[LineTime]
    def logText: Option[LogText]
    def logFilter: Option[zio.aws.applicationinsights.model.LogFilter]
    def metricNamespace: Option[MetricNamespace]
    def metricName: Option[MetricName]
    def unit: Option[zio.aws.applicationinsights.model.primitives.Unit]
    def value: Option[Value]
    def cloudWatchEventId: Option[CloudWatchEventId]
    def cloudWatchEventSource
        : Option[zio.aws.applicationinsights.model.CloudWatchEventSource]
    def cloudWatchEventDetailType: Option[CloudWatchEventDetailType]
    def healthEventArn: Option[HealthEventArn]
    def healthService: Option[HealthService]
    def healthEventTypeCode: Option[HealthEventTypeCode]
    def healthEventTypeCategory: Option[HealthEventTypeCategory]
    def healthEventDescription: Option[HealthEventDescription]
    def codeDeployDeploymentId: Option[CodeDeployDeploymentId]
    def codeDeployDeploymentGroup: Option[CodeDeployDeploymentGroup]
    def codeDeployState: Option[CodeDeployState]
    def codeDeployApplication: Option[CodeDeployApplication]
    def codeDeployInstanceGroupId: Option[CodeDeployInstanceGroupId]
    def ec2State: Option[Ec2State]
    def rdsEventCategories: Option[RdsEventCategories]
    def rdsEventMessage: Option[RdsEventMessage]
    def s3EventName: Option[S3EventName]
    def statesExecutionArn: Option[StatesExecutionArn]
    def statesArn: Option[StatesArn]
    def statesStatus: Option[StatesStatus]
    def statesInput: Option[StatesInput]
    def ebsEvent: Option[EbsEvent]
    def ebsResult: Option[EbsResult]
    def ebsCause: Option[EbsCause]
    def ebsRequestId: Option[EbsRequestId]
    def xRayFaultPercent: Option[XRayFaultPercent]
    def xRayThrottlePercent: Option[XRayThrottlePercent]
    def xRayErrorPercent: Option[XRayErrorPercent]
    def xRayRequestCount: Option[XRayRequestCount]
    def xRayRequestAverageLatency: Option[XRayRequestAverageLatency]
    def xRayNodeName: Option[XRayNodeName]
    def xRayNodeType: Option[XRayNodeType]
    def getId: ZIO[Any, AwsError, ObservationId] =
      AwsError.unwrapOptionField("id", id)
    def getStartTime: ZIO[Any, AwsError, StartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, EndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getSourceType: ZIO[Any, AwsError, SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getSourceARN: ZIO[Any, AwsError, SourceARN] =
      AwsError.unwrapOptionField("sourceARN", sourceARN)
    def getLogGroup: ZIO[Any, AwsError, LogGroup] =
      AwsError.unwrapOptionField("logGroup", logGroup)
    def getLineTime: ZIO[Any, AwsError, LineTime] =
      AwsError.unwrapOptionField("lineTime", lineTime)
    def getLogText: ZIO[Any, AwsError, LogText] =
      AwsError.unwrapOptionField("logText", logText)
    def getLogFilter
        : ZIO[Any, AwsError, zio.aws.applicationinsights.model.LogFilter] =
      AwsError.unwrapOptionField("logFilter", logFilter)
    def getMetricNamespace: ZIO[Any, AwsError, MetricNamespace] =
      AwsError.unwrapOptionField("metricNamespace", metricNamespace)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getUnit: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.primitives.Unit
    ] = AwsError.unwrapOptionField("unit", unit)
    def getValue: ZIO[Any, AwsError, Value] =
      AwsError.unwrapOptionField("value", value)
    def getCloudWatchEventId: ZIO[Any, AwsError, CloudWatchEventId] =
      AwsError.unwrapOptionField("cloudWatchEventId", cloudWatchEventId)
    def getCloudWatchEventSource: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.CloudWatchEventSource
    ] =
      AwsError.unwrapOptionField("cloudWatchEventSource", cloudWatchEventSource)
    def getCloudWatchEventDetailType
        : ZIO[Any, AwsError, CloudWatchEventDetailType] = AwsError
      .unwrapOptionField("cloudWatchEventDetailType", cloudWatchEventDetailType)
    def getHealthEventArn: ZIO[Any, AwsError, HealthEventArn] =
      AwsError.unwrapOptionField("healthEventArn", healthEventArn)
    def getHealthService: ZIO[Any, AwsError, HealthService] =
      AwsError.unwrapOptionField("healthService", healthService)
    def getHealthEventTypeCode: ZIO[Any, AwsError, HealthEventTypeCode] =
      AwsError.unwrapOptionField("healthEventTypeCode", healthEventTypeCode)
    def getHealthEventTypeCategory
        : ZIO[Any, AwsError, HealthEventTypeCategory] = AwsError
      .unwrapOptionField("healthEventTypeCategory", healthEventTypeCategory)
    def getHealthEventDescription: ZIO[Any, AwsError, HealthEventDescription] =
      AwsError.unwrapOptionField(
        "healthEventDescription",
        healthEventDescription
      )
    def getCodeDeployDeploymentId: ZIO[Any, AwsError, CodeDeployDeploymentId] =
      AwsError.unwrapOptionField(
        "codeDeployDeploymentId",
        codeDeployDeploymentId
      )
    def getCodeDeployDeploymentGroup
        : ZIO[Any, AwsError, CodeDeployDeploymentGroup] = AwsError
      .unwrapOptionField("codeDeployDeploymentGroup", codeDeployDeploymentGroup)
    def getCodeDeployState: ZIO[Any, AwsError, CodeDeployState] =
      AwsError.unwrapOptionField("codeDeployState", codeDeployState)
    def getCodeDeployApplication: ZIO[Any, AwsError, CodeDeployApplication] =
      AwsError.unwrapOptionField("codeDeployApplication", codeDeployApplication)
    def getCodeDeployInstanceGroupId
        : ZIO[Any, AwsError, CodeDeployInstanceGroupId] = AwsError
      .unwrapOptionField("codeDeployInstanceGroupId", codeDeployInstanceGroupId)
    def getEc2State: ZIO[Any, AwsError, Ec2State] =
      AwsError.unwrapOptionField("ec2State", ec2State)
    def getRdsEventCategories: ZIO[Any, AwsError, RdsEventCategories] =
      AwsError.unwrapOptionField("rdsEventCategories", rdsEventCategories)
    def getRdsEventMessage: ZIO[Any, AwsError, RdsEventMessage] =
      AwsError.unwrapOptionField("rdsEventMessage", rdsEventMessage)
    def getS3EventName: ZIO[Any, AwsError, S3EventName] =
      AwsError.unwrapOptionField("s3EventName", s3EventName)
    def getStatesExecutionArn: ZIO[Any, AwsError, StatesExecutionArn] =
      AwsError.unwrapOptionField("statesExecutionArn", statesExecutionArn)
    def getStatesArn: ZIO[Any, AwsError, StatesArn] =
      AwsError.unwrapOptionField("statesArn", statesArn)
    def getStatesStatus: ZIO[Any, AwsError, StatesStatus] =
      AwsError.unwrapOptionField("statesStatus", statesStatus)
    def getStatesInput: ZIO[Any, AwsError, StatesInput] =
      AwsError.unwrapOptionField("statesInput", statesInput)
    def getEbsEvent: ZIO[Any, AwsError, EbsEvent] =
      AwsError.unwrapOptionField("ebsEvent", ebsEvent)
    def getEbsResult: ZIO[Any, AwsError, EbsResult] =
      AwsError.unwrapOptionField("ebsResult", ebsResult)
    def getEbsCause: ZIO[Any, AwsError, EbsCause] =
      AwsError.unwrapOptionField("ebsCause", ebsCause)
    def getEbsRequestId: ZIO[Any, AwsError, EbsRequestId] =
      AwsError.unwrapOptionField("ebsRequestId", ebsRequestId)
    def getXRayFaultPercent: ZIO[Any, AwsError, XRayFaultPercent] =
      AwsError.unwrapOptionField("xRayFaultPercent", xRayFaultPercent)
    def getXRayThrottlePercent: ZIO[Any, AwsError, XRayThrottlePercent] =
      AwsError.unwrapOptionField("xRayThrottlePercent", xRayThrottlePercent)
    def getXRayErrorPercent: ZIO[Any, AwsError, XRayErrorPercent] =
      AwsError.unwrapOptionField("xRayErrorPercent", xRayErrorPercent)
    def getXRayRequestCount: ZIO[Any, AwsError, XRayRequestCount] =
      AwsError.unwrapOptionField("xRayRequestCount", xRayRequestCount)
    def getXRayRequestAverageLatency
        : ZIO[Any, AwsError, XRayRequestAverageLatency] = AwsError
      .unwrapOptionField("xRayRequestAverageLatency", xRayRequestAverageLatency)
    def getXRayNodeName: ZIO[Any, AwsError, XRayNodeName] =
      AwsError.unwrapOptionField("xRayNodeName", xRayNodeName)
    def getXRayNodeType: ZIO[Any, AwsError, XRayNodeType] =
      AwsError.unwrapOptionField("xRayNodeType", xRayNodeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.Observation
  ) extends zio.aws.applicationinsights.model.Observation.ReadOnly {
    override val id: Option[ObservationId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ObservationId(value)
      )
    override val startTime: Option[StartTime] = scala
      .Option(impl.startTime())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.StartTime(value)
      )
    override val endTime: Option[EndTime] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.applicationinsights.model.primitives.EndTime(value))
    override val sourceType: Option[SourceType] = scala
      .Option(impl.sourceType())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.SourceType(value)
      )
    override val sourceARN: Option[SourceARN] = scala
      .Option(impl.sourceARN())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.SourceARN(value)
      )
    override val logGroup: Option[LogGroup] = scala
      .Option(impl.logGroup())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LogGroup(value)
      )
    override val lineTime: Option[LineTime] = scala
      .Option(impl.lineTime())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LineTime(value)
      )
    override val logText: Option[LogText] = scala
      .Option(impl.logText())
      .map(value => zio.aws.applicationinsights.model.primitives.LogText(value))
    override val logFilter
        : Option[zio.aws.applicationinsights.model.LogFilter] = scala
      .Option(impl.logFilter())
      .map(value => zio.aws.applicationinsights.model.LogFilter.wrap(value))
    override val metricNamespace: Option[MetricNamespace] = scala
      .Option(impl.metricNamespace())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.MetricNamespace(value)
      )
    override val metricName: Option[MetricName] = scala
      .Option(impl.metricName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.MetricName(value)
      )
    override val unit
        : Option[zio.aws.applicationinsights.model.primitives.Unit] = scala
      .Option(impl.unit())
      .map(value => zio.aws.applicationinsights.model.primitives.Unit(value))
    override val value: Option[Value] = scala
      .Option(impl.value())
      .map(value => zio.aws.applicationinsights.model.primitives.Value(value))
    override val cloudWatchEventId: Option[CloudWatchEventId] = scala
      .Option(impl.cloudWatchEventId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.CloudWatchEventId(value)
      )
    override val cloudWatchEventSource
        : Option[zio.aws.applicationinsights.model.CloudWatchEventSource] =
      scala
        .Option(impl.cloudWatchEventSource())
        .map(value =>
          zio.aws.applicationinsights.model.CloudWatchEventSource.wrap(value)
        )
    override val cloudWatchEventDetailType: Option[CloudWatchEventDetailType] =
      scala
        .Option(impl.cloudWatchEventDetailType())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .CloudWatchEventDetailType(value)
        )
    override val healthEventArn: Option[HealthEventArn] = scala
      .Option(impl.healthEventArn())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.HealthEventArn(value)
      )
    override val healthService: Option[HealthService] = scala
      .Option(impl.healthService())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.HealthService(value)
      )
    override val healthEventTypeCode: Option[HealthEventTypeCode] = scala
      .Option(impl.healthEventTypeCode())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.HealthEventTypeCode(value)
      )
    override val healthEventTypeCategory: Option[HealthEventTypeCategory] =
      scala
        .Option(impl.healthEventTypeCategory())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .HealthEventTypeCategory(value)
        )
    override val healthEventDescription: Option[HealthEventDescription] = scala
      .Option(impl.healthEventDescription())
      .map(value =>
        zio.aws.applicationinsights.model.primitives
          .HealthEventDescription(value)
      )
    override val codeDeployDeploymentId: Option[CodeDeployDeploymentId] = scala
      .Option(impl.codeDeployDeploymentId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives
          .CodeDeployDeploymentId(value)
      )
    override val codeDeployDeploymentGroup: Option[CodeDeployDeploymentGroup] =
      scala
        .Option(impl.codeDeployDeploymentGroup())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .CodeDeployDeploymentGroup(value)
        )
    override val codeDeployState: Option[CodeDeployState] = scala
      .Option(impl.codeDeployState())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.CodeDeployState(value)
      )
    override val codeDeployApplication: Option[CodeDeployApplication] = scala
      .Option(impl.codeDeployApplication())
      .map(value =>
        zio.aws.applicationinsights.model.primitives
          .CodeDeployApplication(value)
      )
    override val codeDeployInstanceGroupId: Option[CodeDeployInstanceGroupId] =
      scala
        .Option(impl.codeDeployInstanceGroupId())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .CodeDeployInstanceGroupId(value)
        )
    override val ec2State: Option[Ec2State] = scala
      .Option(impl.ec2State())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.Ec2State(value)
      )
    override val rdsEventCategories: Option[RdsEventCategories] = scala
      .Option(impl.rdsEventCategories())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.RdsEventCategories(value)
      )
    override val rdsEventMessage: Option[RdsEventMessage] = scala
      .Option(impl.rdsEventMessage())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.RdsEventMessage(value)
      )
    override val s3EventName: Option[S3EventName] = scala
      .Option(impl.s3EventName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.S3EventName(value)
      )
    override val statesExecutionArn: Option[StatesExecutionArn] = scala
      .Option(impl.statesExecutionArn())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.StatesExecutionArn(value)
      )
    override val statesArn: Option[StatesArn] = scala
      .Option(impl.statesArn())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.StatesArn(value)
      )
    override val statesStatus: Option[StatesStatus] = scala
      .Option(impl.statesStatus())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.StatesStatus(value)
      )
    override val statesInput: Option[StatesInput] = scala
      .Option(impl.statesInput())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.StatesInput(value)
      )
    override val ebsEvent: Option[EbsEvent] = scala
      .Option(impl.ebsEvent())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.EbsEvent(value)
      )
    override val ebsResult: Option[EbsResult] = scala
      .Option(impl.ebsResult())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.EbsResult(value)
      )
    override val ebsCause: Option[EbsCause] = scala
      .Option(impl.ebsCause())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.EbsCause(value)
      )
    override val ebsRequestId: Option[EbsRequestId] = scala
      .Option(impl.ebsRequestId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.EbsRequestId(value)
      )
    override val xRayFaultPercent: Option[XRayFaultPercent] = scala
      .Option(impl.xRayFaultPercent())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.XRayFaultPercent(value)
      )
    override val xRayThrottlePercent: Option[XRayThrottlePercent] = scala
      .Option(impl.xRayThrottlePercent())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.XRayThrottlePercent(value)
      )
    override val xRayErrorPercent: Option[XRayErrorPercent] = scala
      .Option(impl.xRayErrorPercent())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.XRayErrorPercent(value)
      )
    override val xRayRequestCount: Option[XRayRequestCount] = scala
      .Option(impl.xRayRequestCount())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.XRayRequestCount(value)
      )
    override val xRayRequestAverageLatency: Option[XRayRequestAverageLatency] =
      scala
        .Option(impl.xRayRequestAverageLatency())
        .map(value =>
          zio.aws.applicationinsights.model.primitives
            .XRayRequestAverageLatency(value)
        )
    override val xRayNodeName: Option[XRayNodeName] = scala
      .Option(impl.xRayNodeName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.XRayNodeName(value)
      )
    override val xRayNodeType: Option[XRayNodeType] = scala
      .Option(impl.xRayNodeType())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.XRayNodeType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.Observation
  ): zio.aws.applicationinsights.model.Observation.ReadOnly = new Wrapper(impl)
}
