package zio.aws.applicationinsights.model
import java.lang.Integer
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  LogPatternSetName,
  LogPatternRank,
  ResourceGroupName,
  LogPatternName,
  LogPatternRegex
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateLogPatternRequest(
    resourceGroupName: ResourceGroupName,
    patternSetName: LogPatternSetName,
    patternName: LogPatternName,
    pattern: Option[LogPatternRegex] = None,
    rank: Option[LogPatternRank] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.UpdateLogPatternRequest = {
    import UpdateLogPatternRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.UpdateLogPatternRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .patternSetName(
        LogPatternSetName.unwrap(patternSetName): java.lang.String
      )
      .patternName(LogPatternName.unwrap(patternName): java.lang.String)
      .optionallyWith(
        pattern.map(value => LogPatternRegex.unwrap(value): java.lang.String)
      )(_.pattern)
      .optionallyWith(rank.map(value => LogPatternRank.unwrap(value): Integer))(
        _.rank
      )
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.UpdateLogPatternRequest.ReadOnly =
    zio.aws.applicationinsights.model.UpdateLogPatternRequest
      .wrap(buildAwsValue())
}
object UpdateLogPatternRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.UpdateLogPatternRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.UpdateLogPatternRequest =
      zio.aws.applicationinsights.model.UpdateLogPatternRequest(
        resourceGroupName,
        patternSetName,
        patternName,
        pattern.map(value => value),
        rank.map(value => value)
      )
    def resourceGroupName: ResourceGroupName
    def patternSetName: LogPatternSetName
    def patternName: LogPatternName
    def pattern: Option[LogPatternRegex]
    def rank: Option[LogPatternRank]
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getPatternSetName: ZIO[Any, Nothing, LogPatternSetName] =
      ZIO.succeed(patternSetName)
    def getPatternName: ZIO[Any, Nothing, LogPatternName] =
      ZIO.succeed(patternName)
    def getPattern: ZIO[Any, AwsError, LogPatternRegex] =
      AwsError.unwrapOptionField("pattern", pattern)
    def getRank: ZIO[Any, AwsError, LogPatternRank] =
      AwsError.unwrapOptionField("rank", rank)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateLogPatternRequest
  ) extends zio.aws.applicationinsights.model.UpdateLogPatternRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val patternSetName: LogPatternSetName =
      zio.aws.applicationinsights.model.primitives
        .LogPatternSetName(impl.patternSetName())
    override val patternName: LogPatternName =
      zio.aws.applicationinsights.model.primitives
        .LogPatternName(impl.patternName())
    override val pattern: Option[LogPatternRegex] = scala
      .Option(impl.pattern())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LogPatternRegex(value)
      )
    override val rank: Option[LogPatternRank] = scala
      .Option(impl.rank())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LogPatternRank(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateLogPatternRequest
  ): zio.aws.applicationinsights.model.UpdateLogPatternRequest.ReadOnly =
    new Wrapper(impl)
}
