package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.ProblemId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeProblemObservationsRequest(problemId: ProblemId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeProblemObservationsRequest = {
    import DescribeProblemObservationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeProblemObservationsRequest
      .builder()
      .problemId(ProblemId.unwrap(problemId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeProblemObservationsRequest.ReadOnly =
    zio.aws.applicationinsights.model.DescribeProblemObservationsRequest
      .wrap(buildAwsValue())
}
object DescribeProblemObservationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeProblemObservationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeProblemObservationsRequest =
      zio.aws.applicationinsights.model
        .DescribeProblemObservationsRequest(problemId)
    def problemId: ProblemId
    def getProblemId: ZIO[Any, Nothing, ProblemId] = ZIO.succeed(problemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeProblemObservationsRequest
  ) extends zio.aws.applicationinsights.model.DescribeProblemObservationsRequest.ReadOnly {
    override val problemId: ProblemId =
      zio.aws.applicationinsights.model.primitives.ProblemId(impl.problemId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeProblemObservationsRequest
  ): zio.aws.applicationinsights.model.DescribeProblemObservationsRequest.ReadOnly =
    new Wrapper(impl)
}
