package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  OpsItemSNSTopicArn,
  AutoConfigEnabled,
  LifeCycle,
  Remarks,
  ResourceGroupName,
  CWEMonitorEnabled,
  OpsCenterEnabled
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ApplicationInfo(
    resourceGroupName: Option[ResourceGroupName] = None,
    lifeCycle: Option[LifeCycle] = None,
    opsItemSNSTopicArn: Option[OpsItemSNSTopicArn] = None,
    opsCenterEnabled: Option[OpsCenterEnabled] = None,
    cweMonitorEnabled: Option[CWEMonitorEnabled] = None,
    remarks: Option[Remarks] = None,
    autoConfigEnabled: Option[AutoConfigEnabled] = None,
    discoveryType: Option[zio.aws.applicationinsights.model.DiscoveryType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ApplicationInfo = {
    import ApplicationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ApplicationInfo
      .builder()
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .optionallyWith(
        lifeCycle.map(value => LifeCycle.unwrap(value): java.lang.String)
      )(_.lifeCycle)
      .optionallyWith(
        opsItemSNSTopicArn.map(value =>
          OpsItemSNSTopicArn.unwrap(value): java.lang.String
        )
      )(_.opsItemSNSTopicArn)
      .optionallyWith(
        opsCenterEnabled.map(value =>
          OpsCenterEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.opsCenterEnabled)
      .optionallyWith(
        cweMonitorEnabled.map(value =>
          CWEMonitorEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.cweMonitorEnabled)
      .optionallyWith(
        remarks.map(value => Remarks.unwrap(value): java.lang.String)
      )(_.remarks)
      .optionallyWith(
        autoConfigEnabled.map(value =>
          AutoConfigEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.autoConfigEnabled)
      .optionallyWith(discoveryType.map(value => value.unwrap))(_.discoveryType)
      .build()
  }
  def asReadOnly: zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly =
    zio.aws.applicationinsights.model.ApplicationInfo.wrap(buildAwsValue())
}
object ApplicationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ApplicationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ApplicationInfo =
      zio.aws.applicationinsights.model.ApplicationInfo(
        resourceGroupName.map(value => value),
        lifeCycle.map(value => value),
        opsItemSNSTopicArn.map(value => value),
        opsCenterEnabled.map(value => value),
        cweMonitorEnabled.map(value => value),
        remarks.map(value => value),
        autoConfigEnabled.map(value => value),
        discoveryType.map(value => value)
      )
    def resourceGroupName: Option[ResourceGroupName]
    def lifeCycle: Option[LifeCycle]
    def opsItemSNSTopicArn: Option[OpsItemSNSTopicArn]
    def opsCenterEnabled: Option[OpsCenterEnabled]
    def cweMonitorEnabled: Option[CWEMonitorEnabled]
    def remarks: Option[Remarks]
    def autoConfigEnabled: Option[AutoConfigEnabled]
    def discoveryType: Option[zio.aws.applicationinsights.model.DiscoveryType]
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
    def getLifeCycle: ZIO[Any, AwsError, LifeCycle] =
      AwsError.unwrapOptionField("lifeCycle", lifeCycle)
    def getOpsItemSNSTopicArn: ZIO[Any, AwsError, OpsItemSNSTopicArn] =
      AwsError.unwrapOptionField("opsItemSNSTopicArn", opsItemSNSTopicArn)
    def getOpsCenterEnabled: ZIO[Any, AwsError, OpsCenterEnabled] =
      AwsError.unwrapOptionField("opsCenterEnabled", opsCenterEnabled)
    def getCweMonitorEnabled: ZIO[Any, AwsError, CWEMonitorEnabled] =
      AwsError.unwrapOptionField("cweMonitorEnabled", cweMonitorEnabled)
    def getRemarks: ZIO[Any, AwsError, Remarks] =
      AwsError.unwrapOptionField("remarks", remarks)
    def getAutoConfigEnabled: ZIO[Any, AwsError, AutoConfigEnabled] =
      AwsError.unwrapOptionField("autoConfigEnabled", autoConfigEnabled)
    def getDiscoveryType
        : ZIO[Any, AwsError, zio.aws.applicationinsights.model.DiscoveryType] =
      AwsError.unwrapOptionField("discoveryType", discoveryType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ApplicationInfo
  ) extends zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly {
    override val resourceGroupName: Option[ResourceGroupName] = scala
      .Option(impl.resourceGroupName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
      )
    override val lifeCycle: Option[LifeCycle] = scala
      .Option(impl.lifeCycle())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.LifeCycle(value)
      )
    override val opsItemSNSTopicArn: Option[OpsItemSNSTopicArn] = scala
      .Option(impl.opsItemSNSTopicArn())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.OpsItemSNSTopicArn(value)
      )
    override val opsCenterEnabled: Option[OpsCenterEnabled] = scala
      .Option(impl.opsCenterEnabled())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.OpsCenterEnabled(value)
      )
    override val cweMonitorEnabled: Option[CWEMonitorEnabled] = scala
      .Option(impl.cweMonitorEnabled())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.CWEMonitorEnabled(value)
      )
    override val remarks: Option[Remarks] = scala
      .Option(impl.remarks())
      .map(value => zio.aws.applicationinsights.model.primitives.Remarks(value))
    override val autoConfigEnabled: Option[AutoConfigEnabled] = scala
      .Option(impl.autoConfigEnabled())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.AutoConfigEnabled(value)
      )
    override val discoveryType
        : Option[zio.aws.applicationinsights.model.DiscoveryType] = scala
      .Option(impl.discoveryType())
      .map(value => zio.aws.applicationinsights.model.DiscoveryType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ApplicationInfo
  ): zio.aws.applicationinsights.model.ApplicationInfo.ReadOnly = new Wrapper(
    impl
  )
}
