package zio.aws.applicationinsights.model
import scala.jdk.CollectionConverters._
sealed trait Tier {
  def unwrap: software.amazon.awssdk.services.applicationinsights.model.Tier
}
object Tier {
  def wrap(
      value: software.amazon.awssdk.services.applicationinsights.model.Tier
  ): zio.aws.applicationinsights.model.Tier = value match {
    case software.amazon.awssdk.services.applicationinsights.model.Tier.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationinsights.model.Tier.CUSTOM =>
      val r = CUSTOM
      r
    case software.amazon.awssdk.services.applicationinsights.model.Tier.DEFAULT =>
      val r = DEFAULT
      r
    case software.amazon.awssdk.services.applicationinsights.model.Tier.DOT_NET_CORE =>
      val r = DOT_NET_CORE
      r
    case software.amazon.awssdk.services.applicationinsights.model.Tier.DOT_NET_WORKER =>
      val r = DOT_NET_WORKER
      r
    case software.amazon.awssdk.services.applicationinsights.model.Tier.DOT_NET_WEB_TIER =>
      val r = DOT_NET_WEB_TIER
      r
    case software.amazon.awssdk.services.applicationinsights.model.Tier.DOT_NET_WEB =>
      val r = DOT_NET_WEB
      r
    case software.amazon.awssdk.services.applicationinsights.model.Tier.SQL_SERVER =>
      val r = SQL_SERVER
      r
    case software.amazon.awssdk.services.applicationinsights.model.Tier.SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP =>
      val r = SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP
      r
    case software.amazon.awssdk.services.applicationinsights.model.Tier.MYSQL =>
      val r = MYSQL
      r
    case software.amazon.awssdk.services.applicationinsights.model.Tier.POSTGRESQL =>
      val r = POSTGRESQL
      r
    case software.amazon.awssdk.services.applicationinsights.model.Tier.JAVA_JMX =>
      val r = JAVA_JMX
      r
    case software.amazon.awssdk.services.applicationinsights.model.Tier.ORACLE =>
      val r = ORACLE
      r
    case software.amazon.awssdk.services.applicationinsights.model.Tier.SAP_HANA_MULTI_NODE =>
      val r = SAP_HANA_MULTI_NODE
      r
    case software.amazon.awssdk.services.applicationinsights.model.Tier.SAP_HANA_SINGLE_NODE =>
      val r = SAP_HANA_SINGLE_NODE
      r
    case software.amazon.awssdk.services.applicationinsights.model.Tier.SAP_HANA_HIGH_AVAILABILITY =>
      val r = SAP_HANA_HIGH_AVAILABILITY
      r
    case software.amazon.awssdk.services.applicationinsights.model.Tier.SQL_SERVER_FAILOVER_CLUSTER_INSTANCE =>
      val r = SQL_SERVER_FAILOVER_CLUSTER_INSTANCE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.UNKNOWN_TO_SDK_VERSION
  }
  case object CUSTOM extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.CUSTOM
  }
  case object DEFAULT extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.DEFAULT
  }
  case object DOT_NET_CORE extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.DOT_NET_CORE
  }
  case object DOT_NET_WORKER extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.DOT_NET_WORKER
  }
  case object DOT_NET_WEB_TIER extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.DOT_NET_WEB_TIER
  }
  case object DOT_NET_WEB extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.DOT_NET_WEB
  }
  case object SQL_SERVER extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.SQL_SERVER
  }
  case object SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP
      extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP
  }
  case object MYSQL extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.MYSQL
  }
  case object POSTGRESQL extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.POSTGRESQL
  }
  case object JAVA_JMX extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.JAVA_JMX
  }
  case object ORACLE extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.ORACLE
  }
  case object SAP_HANA_MULTI_NODE
      extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.SAP_HANA_MULTI_NODE
  }
  case object SAP_HANA_SINGLE_NODE
      extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.SAP_HANA_SINGLE_NODE
  }
  case object SAP_HANA_HIGH_AVAILABILITY
      extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.SAP_HANA_HIGH_AVAILABILITY
  }
  case object SQL_SERVER_FAILOVER_CLUSTER_INSTANCE
      extends zio.aws.applicationinsights.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Tier =
      software.amazon.awssdk.services.applicationinsights.model.Tier.SQL_SERVER_FAILOVER_CLUSTER_INSTANCE
  }
}
