package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  ResourceGroupName,
  PaginationToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListProblemsResponse(
    problemList: Option[Iterable[zio.aws.applicationinsights.model.Problem]] =
      None,
    nextToken: Option[PaginationToken] = None,
    resourceGroupName: Option[ResourceGroupName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.ListProblemsResponse = {
    import ListProblemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.ListProblemsResponse
      .builder()
      .optionallyWith(
        problemList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.problemList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        resourceGroupName.map(value =>
          ResourceGroupName.unwrap(value): java.lang.String
        )
      )(_.resourceGroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.ListProblemsResponse.ReadOnly =
    zio.aws.applicationinsights.model.ListProblemsResponse.wrap(buildAwsValue())
}
object ListProblemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.ListProblemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.ListProblemsResponse =
      zio.aws.applicationinsights.model.ListProblemsResponse(
        problemList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        resourceGroupName.map(value => value)
      )
    def problemList
        : Option[List[zio.aws.applicationinsights.model.Problem.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def resourceGroupName: Option[ResourceGroupName]
    def getProblemList: ZIO[Any, AwsError, List[
      zio.aws.applicationinsights.model.Problem.ReadOnly
    ]] = AwsError.unwrapOptionField("problemList", problemList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceGroupName: ZIO[Any, AwsError, ResourceGroupName] =
      AwsError.unwrapOptionField("resourceGroupName", resourceGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListProblemsResponse
  ) extends zio.aws.applicationinsights.model.ListProblemsResponse.ReadOnly {
    override val problemList
        : Option[List[zio.aws.applicationinsights.model.Problem.ReadOnly]] =
      scala
        .Option(impl.problemList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.applicationinsights.model.Problem.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.PaginationToken(value)
      )
    override val resourceGroupName: Option[ResourceGroupName] = scala
      .Option(impl.resourceGroupName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ResourceGroupName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.ListProblemsResponse
  ): zio.aws.applicationinsights.model.ListProblemsResponse.ReadOnly =
    new Wrapper(impl)
}
