package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  OpsItemSNSTopicArn,
  AutoConfigEnabled,
  RemoveSNSTopic,
  ResourceGroupName,
  CWEMonitorEnabled,
  OpsCenterEnabled
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateApplicationRequest(
    resourceGroupName: ResourceGroupName,
    opsCenterEnabled: Option[OpsCenterEnabled] = None,
    cweMonitorEnabled: Option[CWEMonitorEnabled] = None,
    opsItemSNSTopicArn: Option[OpsItemSNSTopicArn] = None,
    removeSNSTopic: Option[RemoveSNSTopic] = None,
    autoConfigEnabled: Option[AutoConfigEnabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationRequest = {
    import UpdateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .optionallyWith(
        opsCenterEnabled.map(value =>
          OpsCenterEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.opsCenterEnabled)
      .optionallyWith(
        cweMonitorEnabled.map(value =>
          CWEMonitorEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.cweMonitorEnabled)
      .optionallyWith(
        opsItemSNSTopicArn.map(value =>
          OpsItemSNSTopicArn.unwrap(value): java.lang.String
        )
      )(_.opsItemSNSTopicArn)
      .optionallyWith(
        removeSNSTopic.map(value =>
          RemoveSNSTopic.unwrap(value): java.lang.Boolean
        )
      )(_.removeSNSTopic)
      .optionallyWith(
        autoConfigEnabled.map(value =>
          AutoConfigEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.autoConfigEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.UpdateApplicationRequest.ReadOnly =
    zio.aws.applicationinsights.model.UpdateApplicationRequest
      .wrap(buildAwsValue())
}
object UpdateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.UpdateApplicationRequest =
      zio.aws.applicationinsights.model.UpdateApplicationRequest(
        resourceGroupName,
        opsCenterEnabled.map(value => value),
        cweMonitorEnabled.map(value => value),
        opsItemSNSTopicArn.map(value => value),
        removeSNSTopic.map(value => value),
        autoConfigEnabled.map(value => value)
      )
    def resourceGroupName: ResourceGroupName
    def opsCenterEnabled: Option[OpsCenterEnabled]
    def cweMonitorEnabled: Option[CWEMonitorEnabled]
    def opsItemSNSTopicArn: Option[OpsItemSNSTopicArn]
    def removeSNSTopic: Option[RemoveSNSTopic]
    def autoConfigEnabled: Option[AutoConfigEnabled]
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getOpsCenterEnabled: ZIO[Any, AwsError, OpsCenterEnabled] =
      AwsError.unwrapOptionField("opsCenterEnabled", opsCenterEnabled)
    def getCweMonitorEnabled: ZIO[Any, AwsError, CWEMonitorEnabled] =
      AwsError.unwrapOptionField("cweMonitorEnabled", cweMonitorEnabled)
    def getOpsItemSNSTopicArn: ZIO[Any, AwsError, OpsItemSNSTopicArn] =
      AwsError.unwrapOptionField("opsItemSNSTopicArn", opsItemSNSTopicArn)
    def getRemoveSNSTopic: ZIO[Any, AwsError, RemoveSNSTopic] =
      AwsError.unwrapOptionField("removeSNSTopic", removeSNSTopic)
    def getAutoConfigEnabled: ZIO[Any, AwsError, AutoConfigEnabled] =
      AwsError.unwrapOptionField("autoConfigEnabled", autoConfigEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationRequest
  ) extends zio.aws.applicationinsights.model.UpdateApplicationRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val opsCenterEnabled: Option[OpsCenterEnabled] = scala
      .Option(impl.opsCenterEnabled())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.OpsCenterEnabled(value)
      )
    override val cweMonitorEnabled: Option[CWEMonitorEnabled] = scala
      .Option(impl.cweMonitorEnabled())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.CWEMonitorEnabled(value)
      )
    override val opsItemSNSTopicArn: Option[OpsItemSNSTopicArn] = scala
      .Option(impl.opsItemSNSTopicArn())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.OpsItemSNSTopicArn(value)
      )
    override val removeSNSTopic: Option[RemoveSNSTopic] = scala
      .Option(impl.removeSNSTopic())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.RemoveSNSTopic(value)
      )
    override val autoConfigEnabled: Option[AutoConfigEnabled] = scala
      .Option(impl.autoConfigEnabled())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.AutoConfigEnabled(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationRequest
  ): zio.aws.applicationinsights.model.UpdateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
