package zio.aws.applicationinsights.model
import scala.jdk.CollectionConverters._
sealed trait DiscoveryType {
  def unwrap
      : software.amazon.awssdk.services.applicationinsights.model.DiscoveryType
}
object DiscoveryType {
  def wrap(
      value: software.amazon.awssdk.services.applicationinsights.model.DiscoveryType
  ): zio.aws.applicationinsights.model.DiscoveryType = value match {
    case software.amazon.awssdk.services.applicationinsights.model.DiscoveryType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationinsights.model.DiscoveryType.RESOURCE_GROUP_BASED =>
      val r = RESOURCE_GROUP_BASED
      r
    case software.amazon.awssdk.services.applicationinsights.model.DiscoveryType.ACCOUNT_BASED =>
      val r = ACCOUNT_BASED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationinsights.model.DiscoveryType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.DiscoveryType =
      software.amazon.awssdk.services.applicationinsights.model.DiscoveryType.UNKNOWN_TO_SDK_VERSION
  }
  case object RESOURCE_GROUP_BASED
      extends zio.aws.applicationinsights.model.DiscoveryType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.DiscoveryType =
      software.amazon.awssdk.services.applicationinsights.model.DiscoveryType.RESOURCE_GROUP_BASED
  }
  case object ACCOUNT_BASED
      extends zio.aws.applicationinsights.model.DiscoveryType {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.DiscoveryType =
      software.amazon.awssdk.services.applicationinsights.model.DiscoveryType.ACCOUNT_BASED
  }
}
