package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeProblemObservationsResponse(
    relatedObservations: Option[
      zio.aws.applicationinsights.model.RelatedObservations
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeProblemObservationsResponse = {
    import DescribeProblemObservationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeProblemObservationsResponse
      .builder()
      .optionallyWith(relatedObservations.map(value => value.buildAwsValue()))(
        _.relatedObservations
      )
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeProblemObservationsResponse.ReadOnly =
    zio.aws.applicationinsights.model.DescribeProblemObservationsResponse
      .wrap(buildAwsValue())
}
object DescribeProblemObservationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeProblemObservationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationinsights.model.DescribeProblemObservationsResponse =
      zio.aws.applicationinsights.model.DescribeProblemObservationsResponse(
        relatedObservations.map(value => value.asEditable)
      )
    def relatedObservations
        : Option[zio.aws.applicationinsights.model.RelatedObservations.ReadOnly]
    def getRelatedObservations: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.RelatedObservations.ReadOnly
    ] = AwsError.unwrapOptionField("relatedObservations", relatedObservations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeProblemObservationsResponse
  ) extends zio.aws.applicationinsights.model.DescribeProblemObservationsResponse.ReadOnly {
    override val relatedObservations: Option[
      zio.aws.applicationinsights.model.RelatedObservations.ReadOnly
    ] = scala
      .Option(impl.relatedObservations())
      .map(value =>
        zio.aws.applicationinsights.model.RelatedObservations.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeProblemObservationsResponse
  ): zio.aws.applicationinsights.model.DescribeProblemObservationsResponse.ReadOnly =
    new Wrapper(impl)
}
