package zio.aws.applicationcostprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.applicationcostprofiler.model.primitives.{S3Prefix, S3Bucket}
import scala.jdk.CollectionConverters._
final case class S3Location(bucket: S3Bucket, prefix: S3Prefix) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationcostprofiler.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationcostprofiler.model.S3Location
      .builder()
      .bucket(S3Bucket.unwrap(bucket): java.lang.String)
      .prefix(S3Prefix.unwrap(prefix): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.applicationcostprofiler.model.S3Location.ReadOnly =
    zio.aws.applicationcostprofiler.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationcostprofiler.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationcostprofiler.model.S3Location =
      zio.aws.applicationcostprofiler.model.S3Location(bucket, prefix)
    def bucket: S3Bucket
    def prefix: S3Prefix
    def getBucket: ZIO[Any, Nothing, S3Bucket] = ZIO.succeed(bucket)
    def getPrefix: ZIO[Any, Nothing, S3Prefix] = ZIO.succeed(prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.S3Location
  ) extends zio.aws.applicationcostprofiler.model.S3Location.ReadOnly {
    override val bucket: S3Bucket =
      zio.aws.applicationcostprofiler.model.primitives.S3Bucket(impl.bucket())
    override val prefix: S3Prefix =
      zio.aws.applicationcostprofiler.model.primitives.S3Prefix(impl.prefix())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.S3Location
  ): zio.aws.applicationcostprofiler.model.S3Location.ReadOnly = new Wrapper(
    impl
  )
}
