package zio.aws.applicationcostprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.applicationcostprofiler.model.primitives.{Integer, Token}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListReportDefinitionsRequest(
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsRequest = {
    import ListReportDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.applicationcostprofiler.model.ListReportDefinitionsRequest.ReadOnly =
    zio.aws.applicationcostprofiler.model.ListReportDefinitionsRequest
      .wrap(buildAwsValue())
}
object ListReportDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationcostprofiler.model.ListReportDefinitionsRequest =
      zio.aws.applicationcostprofiler.model.ListReportDefinitionsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[Token]
    def maxResults: Optional[Integer]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsRequest
  ) extends zio.aws.applicationcostprofiler.model.ListReportDefinitionsRequest.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.applicationcostprofiler.model.primitives.Token(value)
      )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsRequest
  ): zio.aws.applicationcostprofiler.model.ListReportDefinitionsRequest.ReadOnly =
    new Wrapper(impl)
}
