package zio.aws.applicationcostprofiler.model
import scala.jdk.CollectionConverters._
sealed trait ReportFrequency {
  def unwrap: software.amazon.awssdk.services.applicationcostprofiler.model.ReportFrequency
}
object ReportFrequency {
  def wrap(
      value: software.amazon.awssdk.services.applicationcostprofiler.model.ReportFrequency
  ): zio.aws.applicationcostprofiler.model.ReportFrequency = value match {
    case software.amazon.awssdk.services.applicationcostprofiler.model.ReportFrequency.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationcostprofiler.model.ReportFrequency.MONTHLY =>
      val r = MONTHLY
      r
    case software.amazon.awssdk.services.applicationcostprofiler.model.ReportFrequency.DAILY =>
      val r = DAILY
      r
    case software.amazon.awssdk.services.applicationcostprofiler.model.ReportFrequency.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationcostprofiler.model.ReportFrequency {
    override def unwrap
        : software.amazon.awssdk.services.applicationcostprofiler.model.ReportFrequency =
      software.amazon.awssdk.services.applicationcostprofiler.model.ReportFrequency.UNKNOWN_TO_SDK_VERSION
  }
  case object MONTHLY
      extends zio.aws.applicationcostprofiler.model.ReportFrequency {
    override def unwrap
        : software.amazon.awssdk.services.applicationcostprofiler.model.ReportFrequency =
      software.amazon.awssdk.services.applicationcostprofiler.model.ReportFrequency.MONTHLY
  }
  case object DAILY
      extends zio.aws.applicationcostprofiler.model.ReportFrequency {
    override def unwrap
        : software.amazon.awssdk.services.applicationcostprofiler.model.ReportFrequency =
      software.amazon.awssdk.services.applicationcostprofiler.model.ReportFrequency.DAILY
  }
  case object ALL
      extends zio.aws.applicationcostprofiler.model.ReportFrequency {
    override def unwrap
        : software.amazon.awssdk.services.applicationcostprofiler.model.ReportFrequency =
      software.amazon.awssdk.services.applicationcostprofiler.model.ReportFrequency.ALL
  }
}
