package zio.aws.applicationcostprofiler
import zio.mock.{Proxy, Mock}
import zio.aws.applicationcostprofiler.model.PutReportDefinitionResponse.ReadOnly
import zio.aws.applicationcostprofiler.model.{
  ListReportDefinitionsRequest,
  GetReportDefinitionRequest,
  UpdateReportDefinitionRequest,
  DeleteReportDefinitionRequest,
  PutReportDefinitionRequest,
  ImportApplicationUsageRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.applicationcostprofiler.ApplicationCostProfilerAsyncClient
import zio.stream.ZStream
object ApplicationCostProfilerMock extends Mock[ApplicationCostProfiler] {
  object ListReportDefinitions
      extends Stream[
        ListReportDefinitionsRequest,
        AwsError,
        zio.aws.applicationcostprofiler.model.ReportDefinition.ReadOnly
      ]
  object ListReportDefinitionsPaginated
      extends Effect[
        ListReportDefinitionsRequest,
        AwsError,
        zio.aws.applicationcostprofiler.model.ListReportDefinitionsResponse.ReadOnly
      ]
  object DeleteReportDefinition
      extends Effect[
        DeleteReportDefinitionRequest,
        AwsError,
        zio.aws.applicationcostprofiler.model.DeleteReportDefinitionResponse.ReadOnly
      ]
  object PutReportDefinition
      extends Effect[PutReportDefinitionRequest, AwsError, ReadOnly]
  object ImportApplicationUsage
      extends Effect[
        ImportApplicationUsageRequest,
        AwsError,
        zio.aws.applicationcostprofiler.model.ImportApplicationUsageResponse.ReadOnly
      ]
  object GetReportDefinition
      extends Effect[
        GetReportDefinitionRequest,
        AwsError,
        zio.aws.applicationcostprofiler.model.GetReportDefinitionResponse.ReadOnly
      ]
  object UpdateReportDefinition
      extends Effect[
        UpdateReportDefinitionRequest,
        AwsError,
        zio.aws.applicationcostprofiler.model.UpdateReportDefinitionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ApplicationCostProfiler] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ApplicationCostProfiler] { rts =>
        zio.ZIO.succeed {
          new ApplicationCostProfiler {
            val api: ApplicationCostProfilerAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ApplicationCostProfiler = this
            def listReportDefinitions(
                request: ListReportDefinitionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.applicationcostprofiler.model.ReportDefinition.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListReportDefinitions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listReportDefinitionsPaginated(
                request: ListReportDefinitionsRequest
            ): IO[
              AwsError,
              zio.aws.applicationcostprofiler.model.ListReportDefinitionsResponse.ReadOnly
            ] = proxy(ListReportDefinitionsPaginated, request)
            def deleteReportDefinition(
                request: DeleteReportDefinitionRequest
            ): IO[
              AwsError,
              zio.aws.applicationcostprofiler.model.DeleteReportDefinitionResponse.ReadOnly
            ] = proxy(DeleteReportDefinition, request)
            def putReportDefinition(
                request: PutReportDefinitionRequest
            ): IO[AwsError, ReadOnly] = proxy(PutReportDefinition, request)
            def importApplicationUsage(
                request: ImportApplicationUsageRequest
            ): IO[
              AwsError,
              zio.aws.applicationcostprofiler.model.ImportApplicationUsageResponse.ReadOnly
            ] = proxy(ImportApplicationUsage, request)
            def getReportDefinition(request: GetReportDefinitionRequest): IO[
              AwsError,
              zio.aws.applicationcostprofiler.model.GetReportDefinitionResponse.ReadOnly
            ] = proxy(GetReportDefinition, request)
            def updateReportDefinition(
                request: UpdateReportDefinitionRequest
            ): IO[
              AwsError,
              zio.aws.applicationcostprofiler.model.UpdateReportDefinitionResponse.ReadOnly
            ] = proxy(UpdateReportDefinition, request)
          }
        }
      }
    }
  }
}
