package zio.aws.applicationcostprofiler
import zio.aws.core.config.AwsConfig
import zio.aws.applicationcostprofiler.model.PutReportDefinitionResponse.ReadOnly
import zio.aws.applicationcostprofiler.model.{
  ListReportDefinitionsRequest,
  GetReportDefinitionRequest,
  UpdateReportDefinitionRequest,
  DeleteReportDefinitionRequest,
  PutReportDefinitionRequest,
  ImportApplicationUsageRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.applicationcostprofiler.{
  ApplicationCostProfilerAsyncClientBuilder,
  ApplicationCostProfilerAsyncClient
}
import software.amazon.awssdk.services.applicationcostprofiler.model.{
  ReportDefinition,
  GetReportDefinitionResponse,
  ImportApplicationUsageResponse,
  PutReportDefinitionResponse,
  DeleteReportDefinitionResponse,
  ListReportDefinitionsResponse,
  UpdateReportDefinitionResponse
}
import zio.stream.ZStream
import software.amazon.awssdk.services.applicationcostprofiler.paginators.ListReportDefinitionsPublisher
import scala.jdk.CollectionConverters._
trait ApplicationCostProfiler extends AspectSupport[ApplicationCostProfiler] {
  val api: ApplicationCostProfilerAsyncClient
  def listReportDefinitions(request: ListReportDefinitionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.applicationcostprofiler.model.ReportDefinition.ReadOnly
  ]
  def listReportDefinitionsPaginated(request: ListReportDefinitionsRequest): IO[
    AwsError,
    zio.aws.applicationcostprofiler.model.ListReportDefinitionsResponse.ReadOnly
  ]
  def deleteReportDefinition(request: DeleteReportDefinitionRequest): IO[
    AwsError,
    zio.aws.applicationcostprofiler.model.DeleteReportDefinitionResponse.ReadOnly
  ]
  def putReportDefinition(
      request: PutReportDefinitionRequest
  ): IO[AwsError, ReadOnly]
  def importApplicationUsage(request: ImportApplicationUsageRequest): IO[
    AwsError,
    zio.aws.applicationcostprofiler.model.ImportApplicationUsageResponse.ReadOnly
  ]
  def getReportDefinition(request: GetReportDefinitionRequest): IO[
    AwsError,
    zio.aws.applicationcostprofiler.model.GetReportDefinitionResponse.ReadOnly
  ]
  def updateReportDefinition(request: UpdateReportDefinitionRequest): IO[
    AwsError,
    zio.aws.applicationcostprofiler.model.UpdateReportDefinitionResponse.ReadOnly
  ]
}
object ApplicationCostProfiler {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ApplicationCostProfiler] =
    customized(identity)
  def customized(
      customization: ApplicationCostProfilerAsyncClientBuilder => ApplicationCostProfilerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ApplicationCostProfiler] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ApplicationCostProfilerAsyncClientBuilder => ApplicationCostProfilerAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ApplicationCostProfiler] =
    for (
      awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
      builder = ApplicationCostProfilerAsyncClient
        .builder()
        .asyncConfiguration(
          software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
            .builder()
            .advancedOption(
              software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
              executor.asJava
            )
            .build()
        );
      b0 <- awsConfig.configure[
        ApplicationCostProfilerAsyncClient,
        ApplicationCostProfilerAsyncClientBuilder
      ](builder);
      b1 <- awsConfig.configureHttpClient[
        ApplicationCostProfilerAsyncClient,
        ApplicationCostProfilerAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
    )
      yield new ApplicationCostProfilerImpl(
        client,
        AwsCallAspect.identity,
        ZEnvironment.empty
      )
  private class ApplicationCostProfilerImpl[R](
      override val api: ApplicationCostProfilerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ApplicationCostProfiler
      with AwsServiceBase[R] {
    override val serviceName: String = "ApplicationCostProfiler"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ApplicationCostProfilerImpl[R1] =
      new ApplicationCostProfilerImpl(api, newAspect, r)
    def listReportDefinitions(request: ListReportDefinitionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.applicationcostprofiler.model.ReportDefinition.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsRequest,
      ReportDefinition,
      ListReportDefinitionsPublisher
    ](
      "listReportDefinitions",
      api.listReportDefinitionsPaginator,
      _.reportDefinitions()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.applicationcostprofiler.model.ReportDefinition.wrap(item)
      )
      .provideEnvironment(r)
    def listReportDefinitionsPaginated(
        request: ListReportDefinitionsRequest
    ): IO[
      AwsError,
      zio.aws.applicationcostprofiler.model.ListReportDefinitionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsRequest,
      ListReportDefinitionsResponse
    ]("listReportDefinitions", api.listReportDefinitions)(
      request.buildAwsValue()
    ).map(
      zio.aws.applicationcostprofiler.model.ListReportDefinitionsResponse.wrap
    ).provideEnvironment(r)
    def deleteReportDefinition(request: DeleteReportDefinitionRequest): IO[
      AwsError,
      zio.aws.applicationcostprofiler.model.DeleteReportDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationcostprofiler.model.DeleteReportDefinitionRequest,
      DeleteReportDefinitionResponse
    ]("deleteReportDefinition", api.deleteReportDefinition)(
      request.buildAwsValue()
    ).map(
      zio.aws.applicationcostprofiler.model.DeleteReportDefinitionResponse.wrap
    ).provideEnvironment(r)
    def putReportDefinition(
        request: PutReportDefinitionRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationcostprofiler.model.PutReportDefinitionRequest,
      PutReportDefinitionResponse
    ]("putReportDefinition", api.putReportDefinition)(request.buildAwsValue())
      .map(
        zio.aws.applicationcostprofiler.model.PutReportDefinitionResponse.wrap
      )
      .provideEnvironment(r)
    def importApplicationUsage(request: ImportApplicationUsageRequest): IO[
      AwsError,
      zio.aws.applicationcostprofiler.model.ImportApplicationUsageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationcostprofiler.model.ImportApplicationUsageRequest,
      ImportApplicationUsageResponse
    ]("importApplicationUsage", api.importApplicationUsage)(
      request.buildAwsValue()
    ).map(
      zio.aws.applicationcostprofiler.model.ImportApplicationUsageResponse.wrap
    ).provideEnvironment(r)
    def getReportDefinition(request: GetReportDefinitionRequest): IO[
      AwsError,
      zio.aws.applicationcostprofiler.model.GetReportDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationcostprofiler.model.GetReportDefinitionRequest,
      GetReportDefinitionResponse
    ]("getReportDefinition", api.getReportDefinition)(request.buildAwsValue())
      .map(
        zio.aws.applicationcostprofiler.model.GetReportDefinitionResponse.wrap
      )
      .provideEnvironment(r)
    def updateReportDefinition(request: UpdateReportDefinitionRequest): IO[
      AwsError,
      zio.aws.applicationcostprofiler.model.UpdateReportDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.applicationcostprofiler.model.UpdateReportDefinitionRequest,
      UpdateReportDefinitionResponse
    ]("updateReportDefinition", api.updateReportDefinition)(
      request.buildAwsValue()
    ).map(
      zio.aws.applicationcostprofiler.model.UpdateReportDefinitionResponse.wrap
    ).provideEnvironment(r)
  }
  def listReportDefinitions(request: ListReportDefinitionsRequest): ZStream[
    zio.aws.applicationcostprofiler.ApplicationCostProfiler,
    AwsError,
    zio.aws.applicationcostprofiler.model.ReportDefinition.ReadOnly
  ] = ZStream.serviceWithStream(_.listReportDefinitions(request))
  def listReportDefinitionsPaginated(
      request: ListReportDefinitionsRequest
  ): ZIO[
    zio.aws.applicationcostprofiler.ApplicationCostProfiler,
    AwsError,
    zio.aws.applicationcostprofiler.model.ListReportDefinitionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReportDefinitionsPaginated(request))
  def deleteReportDefinition(request: DeleteReportDefinitionRequest): ZIO[
    zio.aws.applicationcostprofiler.ApplicationCostProfiler,
    AwsError,
    zio.aws.applicationcostprofiler.model.DeleteReportDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReportDefinition(request))
  def putReportDefinition(request: PutReportDefinitionRequest): ZIO[
    zio.aws.applicationcostprofiler.ApplicationCostProfiler,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.putReportDefinition(request))
  def importApplicationUsage(request: ImportApplicationUsageRequest): ZIO[
    zio.aws.applicationcostprofiler.ApplicationCostProfiler,
    AwsError,
    zio.aws.applicationcostprofiler.model.ImportApplicationUsageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importApplicationUsage(request))
  def getReportDefinition(request: GetReportDefinitionRequest): ZIO[
    zio.aws.applicationcostprofiler.ApplicationCostProfiler,
    AwsError,
    zio.aws.applicationcostprofiler.model.GetReportDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getReportDefinition(request))
  def updateReportDefinition(request: UpdateReportDefinitionRequest): ZIO[
    zio.aws.applicationcostprofiler.ApplicationCostProfiler,
    AwsError,
    zio.aws.applicationcostprofiler.model.UpdateReportDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateReportDefinition(request))
}
