package zio.aws.applicationcostprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.applicationcostprofiler.model.primitives.ReportId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateReportDefinitionResponse(
    reportId: Optional[ReportId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationcostprofiler.model.UpdateReportDefinitionResponse = {
    import UpdateReportDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationcostprofiler.model.UpdateReportDefinitionResponse
      .builder()
      .optionallyWith(
        reportId.map(value => ReportId.unwrap(value): java.lang.String)
      )(_.reportId)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationcostprofiler.model.UpdateReportDefinitionResponse.ReadOnly =
    zio.aws.applicationcostprofiler.model.UpdateReportDefinitionResponse
      .wrap(buildAwsValue())
}
object UpdateReportDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationcostprofiler.model.UpdateReportDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationcostprofiler.model.UpdateReportDefinitionResponse =
      zio.aws.applicationcostprofiler.model
        .UpdateReportDefinitionResponse(reportId.map(value => value))
    def reportId: Optional[ReportId]
    def getReportId: ZIO[Any, AwsError, ReportId] =
      AwsError.unwrapOptionField("reportId", reportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.UpdateReportDefinitionResponse
  ) extends zio.aws.applicationcostprofiler.model.UpdateReportDefinitionResponse.ReadOnly {
    override val reportId: Optional[ReportId] = zio.aws.core.internal
      .optionalFromNullable(impl.reportId())
      .map(value =>
        zio.aws.applicationcostprofiler.model.primitives.ReportId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.UpdateReportDefinitionResponse
  ): zio.aws.applicationcostprofiler.model.UpdateReportDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
