package zio.aws.applicationcostprofiler.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.applicationcostprofiler.model.primitives.{
  Timestamp,
  ReportDescription,
  ReportId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ReportDefinition(
    reportId: Optional[ReportId] = Optional.Absent,
    reportDescription: Optional[ReportDescription] = Optional.Absent,
    reportFrequency: Optional[
      zio.aws.applicationcostprofiler.model.ReportFrequency
    ] = Optional.Absent,
    format: Optional[zio.aws.applicationcostprofiler.model.Format] =
      Optional.Absent,
    destinationS3Location: Optional[
      zio.aws.applicationcostprofiler.model.S3Location
    ] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationcostprofiler.model.ReportDefinition = {
    import ReportDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationcostprofiler.model.ReportDefinition
      .builder()
      .optionallyWith(
        reportId.map(value => ReportId.unwrap(value): java.lang.String)
      )(_.reportId)
      .optionallyWith(
        reportDescription.map(value =>
          ReportDescription.unwrap(value): java.lang.String
        )
      )(_.reportDescription)
      .optionallyWith(reportFrequency.map(value => value.unwrap))(
        _.reportFrequency
      )
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        destinationS3Location.map(value => value.buildAwsValue())
      )(_.destinationS3Location)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationcostprofiler.model.ReportDefinition.ReadOnly =
    zio.aws.applicationcostprofiler.model.ReportDefinition.wrap(buildAwsValue())
}
object ReportDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationcostprofiler.model.ReportDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationcostprofiler.model.ReportDefinition =
      zio.aws.applicationcostprofiler.model.ReportDefinition(
        reportId.map(value => value),
        reportDescription.map(value => value),
        reportFrequency.map(value => value),
        format.map(value => value),
        destinationS3Location.map(value => value.asEditable),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value)
      )
    def reportId: Optional[ReportId]
    def reportDescription: Optional[ReportDescription]
    def reportFrequency
        : Optional[zio.aws.applicationcostprofiler.model.ReportFrequency]
    def format: Optional[zio.aws.applicationcostprofiler.model.Format]
    def destinationS3Location
        : Optional[zio.aws.applicationcostprofiler.model.S3Location.ReadOnly]
    def createdAt: Optional[Timestamp]
    def lastUpdatedAt: Optional[Timestamp]
    def getReportId: ZIO[Any, AwsError, ReportId] =
      AwsError.unwrapOptionField("reportId", reportId)
    def getReportDescription: ZIO[Any, AwsError, ReportDescription] =
      AwsError.unwrapOptionField("reportDescription", reportDescription)
    def getReportFrequency: ZIO[
      Any,
      AwsError,
      zio.aws.applicationcostprofiler.model.ReportFrequency
    ] = AwsError.unwrapOptionField("reportFrequency", reportFrequency)
    def getFormat
        : ZIO[Any, AwsError, zio.aws.applicationcostprofiler.model.Format] =
      AwsError.unwrapOptionField("format", format)
    def getDestinationS3Location: ZIO[
      Any,
      AwsError,
      zio.aws.applicationcostprofiler.model.S3Location.ReadOnly
    ] =
      AwsError.unwrapOptionField("destinationS3Location", destinationS3Location)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.ReportDefinition
  ) extends zio.aws.applicationcostprofiler.model.ReportDefinition.ReadOnly {
    override val reportId: Optional[ReportId] = zio.aws.core.internal
      .optionalFromNullable(impl.reportId())
      .map(value =>
        zio.aws.applicationcostprofiler.model.primitives.ReportId(value)
      )
    override val reportDescription: Optional[ReportDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportDescription())
        .map(value =>
          zio.aws.applicationcostprofiler.model.primitives
            .ReportDescription(value)
        )
    override val reportFrequency
        : Optional[zio.aws.applicationcostprofiler.model.ReportFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportFrequency())
        .map(value =>
          zio.aws.applicationcostprofiler.model.ReportFrequency.wrap(value)
        )
    override val format
        : Optional[zio.aws.applicationcostprofiler.model.Format] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.applicationcostprofiler.model.Format.wrap(value))
    override val destinationS3Location
        : Optional[zio.aws.applicationcostprofiler.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationS3Location())
        .map(value =>
          zio.aws.applicationcostprofiler.model.S3Location.wrap(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value =>
        zio.aws.applicationcostprofiler.model.primitives.Timestamp(value)
      )
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value =>
        zio.aws.applicationcostprofiler.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.ReportDefinition
  ): zio.aws.applicationcostprofiler.model.ReportDefinition.ReadOnly =
    new Wrapper(impl)
}
