package zio.aws.applicationcostprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.applicationcostprofiler.model.primitives.ReportId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutReportDefinitionResponse(
    reportId: Optional[ReportId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationcostprofiler.model.PutReportDefinitionResponse = {
    import PutReportDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationcostprofiler.model.PutReportDefinitionResponse
      .builder()
      .optionallyWith(
        reportId.map(value => ReportId.unwrap(value): java.lang.String)
      )(_.reportId)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationcostprofiler.model.PutReportDefinitionResponse.ReadOnly =
    zio.aws.applicationcostprofiler.model.PutReportDefinitionResponse
      .wrap(buildAwsValue())
}
object PutReportDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationcostprofiler.model.PutReportDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationcostprofiler.model.PutReportDefinitionResponse =
      zio.aws.applicationcostprofiler.model
        .PutReportDefinitionResponse(reportId.map(value => value))
    def reportId: Optional[ReportId]
    def getReportId: ZIO[Any, AwsError, ReportId] =
      AwsError.unwrapOptionField("reportId", reportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.PutReportDefinitionResponse
  ) extends zio.aws.applicationcostprofiler.model.PutReportDefinitionResponse.ReadOnly {
    override val reportId: Optional[ReportId] = zio.aws.core.internal
      .optionalFromNullable(impl.reportId())
      .map(value =>
        zio.aws.applicationcostprofiler.model.primitives.ReportId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.PutReportDefinitionResponse
  ): zio.aws.applicationcostprofiler.model.PutReportDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
