package zio.aws.applicationcostprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ImportApplicationUsageRequest(
    sourceS3Location: zio.aws.applicationcostprofiler.model.SourceS3Location
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationcostprofiler.model.ImportApplicationUsageRequest = {
    import ImportApplicationUsageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationcostprofiler.model.ImportApplicationUsageRequest
      .builder()
      .sourceS3Location(sourceS3Location.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.applicationcostprofiler.model.ImportApplicationUsageRequest.ReadOnly =
    zio.aws.applicationcostprofiler.model.ImportApplicationUsageRequest
      .wrap(buildAwsValue())
}
object ImportApplicationUsageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationcostprofiler.model.ImportApplicationUsageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationcostprofiler.model.ImportApplicationUsageRequest =
      zio.aws.applicationcostprofiler.model
        .ImportApplicationUsageRequest(sourceS3Location.asEditable)
    def sourceS3Location
        : zio.aws.applicationcostprofiler.model.SourceS3Location.ReadOnly
    def getSourceS3Location: ZIO[
      Any,
      Nothing,
      zio.aws.applicationcostprofiler.model.SourceS3Location.ReadOnly
    ] = ZIO.succeed(sourceS3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.ImportApplicationUsageRequest
  ) extends zio.aws.applicationcostprofiler.model.ImportApplicationUsageRequest.ReadOnly {
    override val sourceS3Location
        : zio.aws.applicationcostprofiler.model.SourceS3Location.ReadOnly =
      zio.aws.applicationcostprofiler.model.SourceS3Location
        .wrap(impl.sourceS3Location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.ImportApplicationUsageRequest
  ): zio.aws.applicationcostprofiler.model.ImportApplicationUsageRequest.ReadOnly =
    new Wrapper(impl)
}
