package zio.aws.applicationcostprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.applicationcostprofiler.model.primitives.ReportId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteReportDefinitionResponse(
    reportId: Optional[ReportId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationcostprofiler.model.DeleteReportDefinitionResponse = {
    import DeleteReportDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationcostprofiler.model.DeleteReportDefinitionResponse
      .builder()
      .optionallyWith(
        reportId.map(value => ReportId.unwrap(value): java.lang.String)
      )(_.reportId)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationcostprofiler.model.DeleteReportDefinitionResponse.ReadOnly =
    zio.aws.applicationcostprofiler.model.DeleteReportDefinitionResponse
      .wrap(buildAwsValue())
}
object DeleteReportDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationcostprofiler.model.DeleteReportDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationcostprofiler.model.DeleteReportDefinitionResponse =
      zio.aws.applicationcostprofiler.model
        .DeleteReportDefinitionResponse(reportId.map(value => value))
    def reportId: Optional[ReportId]
    def getReportId: ZIO[Any, AwsError, ReportId] =
      AwsError.unwrapOptionField("reportId", reportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.DeleteReportDefinitionResponse
  ) extends zio.aws.applicationcostprofiler.model.DeleteReportDefinitionResponse.ReadOnly {
    override val reportId: Optional[ReportId] = zio.aws.core.internal
      .optionalFromNullable(impl.reportId())
      .map(value =>
        zio.aws.applicationcostprofiler.model.primitives.ReportId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.DeleteReportDefinitionResponse
  ): zio.aws.applicationcostprofiler.model.DeleteReportDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
