package zio.aws.applicationcostprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.applicationcostprofiler.model.primitives.ReportId
import scala.jdk.CollectionConverters._
final case class DeleteReportDefinitionRequest(reportId: ReportId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationcostprofiler.model.DeleteReportDefinitionRequest = {
    import DeleteReportDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationcostprofiler.model.DeleteReportDefinitionRequest
      .builder()
      .reportId(ReportId.unwrap(reportId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationcostprofiler.model.DeleteReportDefinitionRequest.ReadOnly =
    zio.aws.applicationcostprofiler.model.DeleteReportDefinitionRequest
      .wrap(buildAwsValue())
}
object DeleteReportDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationcostprofiler.model.DeleteReportDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationcostprofiler.model.DeleteReportDefinitionRequest =
      zio.aws.applicationcostprofiler.model
        .DeleteReportDefinitionRequest(reportId)
    def reportId: ReportId
    def getReportId: ZIO[Any, Nothing, ReportId] = ZIO.succeed(reportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.DeleteReportDefinitionRequest
  ) extends zio.aws.applicationcostprofiler.model.DeleteReportDefinitionRequest.ReadOnly {
    override val reportId: ReportId =
      zio.aws.applicationcostprofiler.model.primitives.ReportId(impl.reportId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.DeleteReportDefinitionRequest
  ): zio.aws.applicationcostprofiler.model.DeleteReportDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
