package zio.aws.applicationcostprofiler.model
import scala.jdk.CollectionConverters._
sealed trait Format {
  def unwrap
      : software.amazon.awssdk.services.applicationcostprofiler.model.Format
}
object Format {
  def wrap(
      value: software.amazon.awssdk.services.applicationcostprofiler.model.Format
  ): zio.aws.applicationcostprofiler.model.Format = value match {
    case software.amazon.awssdk.services.applicationcostprofiler.model.Format.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationcostprofiler.model.Format.CSV =>
      val r = CSV
      r
    case software.amazon.awssdk.services.applicationcostprofiler.model.Format.PARQUET =>
      val r = PARQUET
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationcostprofiler.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.applicationcostprofiler.model.Format =
      software.amazon.awssdk.services.applicationcostprofiler.model.Format.UNKNOWN_TO_SDK_VERSION
  }
  case object CSV extends zio.aws.applicationcostprofiler.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.applicationcostprofiler.model.Format =
      software.amazon.awssdk.services.applicationcostprofiler.model.Format.CSV
  }
  case object PARQUET extends zio.aws.applicationcostprofiler.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.applicationcostprofiler.model.Format =
      software.amazon.awssdk.services.applicationcostprofiler.model.Format.PARQUET
  }
}
