package zio.aws.applicationcostprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.applicationcostprofiler.model.primitives.{S3Key, S3Bucket}
import scala.jdk.CollectionConverters._
final case class SourceS3Location(
    bucket: S3Bucket,
    key: S3Key,
    region: Option[zio.aws.applicationcostprofiler.model.S3BucketRegion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationcostprofiler.model.SourceS3Location = {
    import SourceS3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationcostprofiler.model.SourceS3Location
      .builder()
      .bucket(S3Bucket.unwrap(bucket): java.lang.String)
      .key(S3Key.unwrap(key): java.lang.String)
      .optionallyWith(region.map(value => value.unwrap))(_.region)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationcostprofiler.model.SourceS3Location.ReadOnly =
    zio.aws.applicationcostprofiler.model.SourceS3Location.wrap(buildAwsValue())
}
object SourceS3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationcostprofiler.model.SourceS3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationcostprofiler.model.SourceS3Location =
      zio.aws.applicationcostprofiler.model
        .SourceS3Location(bucket, key, region.map(value => value))
    def bucket: S3Bucket
    def key: S3Key
    def region: Option[zio.aws.applicationcostprofiler.model.S3BucketRegion]
    def getBucket: ZIO[Any, Nothing, S3Bucket] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, S3Key] = ZIO.succeed(key)
    def getRegion: ZIO[
      Any,
      AwsError,
      zio.aws.applicationcostprofiler.model.S3BucketRegion
    ] = AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.SourceS3Location
  ) extends zio.aws.applicationcostprofiler.model.SourceS3Location.ReadOnly {
    override val bucket: S3Bucket =
      zio.aws.applicationcostprofiler.model.primitives.S3Bucket(impl.bucket())
    override val key: S3Key =
      zio.aws.applicationcostprofiler.model.primitives.S3Key(impl.key())
    override val region
        : Option[zio.aws.applicationcostprofiler.model.S3BucketRegion] = scala
      .Option(impl.region())
      .map(value =>
        zio.aws.applicationcostprofiler.model.S3BucketRegion.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.SourceS3Location
  ): zio.aws.applicationcostprofiler.model.SourceS3Location.ReadOnly =
    new Wrapper(impl)
}
