package zio.aws.applicationcostprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.applicationcostprofiler.model.primitives.ReportId
import scala.jdk.CollectionConverters._
final case class GetReportDefinitionRequest(reportId: ReportId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationcostprofiler.model.GetReportDefinitionRequest = {
    import GetReportDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationcostprofiler.model.GetReportDefinitionRequest
      .builder()
      .reportId(ReportId.unwrap(reportId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationcostprofiler.model.GetReportDefinitionRequest.ReadOnly =
    zio.aws.applicationcostprofiler.model.GetReportDefinitionRequest
      .wrap(buildAwsValue())
}
object GetReportDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationcostprofiler.model.GetReportDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationcostprofiler.model.GetReportDefinitionRequest =
      zio.aws.applicationcostprofiler.model.GetReportDefinitionRequest(reportId)
    def reportId: ReportId
    def getReportId: ZIO[Any, Nothing, ReportId] = ZIO.succeed(reportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.GetReportDefinitionRequest
  ) extends zio.aws.applicationcostprofiler.model.GetReportDefinitionRequest.ReadOnly {
    override val reportId: ReportId =
      zio.aws.applicationcostprofiler.model.primitives.ReportId(impl.reportId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.GetReportDefinitionRequest
  ): zio.aws.applicationcostprofiler.model.GetReportDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
